#' Example Cytokine Profiling Data 1.
#'
#' Contains observed concentrations of cytokines and their respective treatment
#' and groups, derived from:
#'
#' @format A data frame with 297 rows and 29 columns:
#' \describe{
#'   \item{Group}{Group assigned to the subjects.}
#'   \item{Treatment}{Treatment received by subjects.}
#'   \item{Time}{Time point of the measurement.}
#'   \item{IL.17F}{Observed concentration of IL.17F cytokine.}
#'   \item{GM.CSF}{Observed concentration of GM.CSF cytokine.}
#'   \item{IFN.G}{Observed concentration of IFN.G cytokine.}
#'   \item{IL.10}{Observed concentration of IL.10 cytokine.}
#'   \item{CCL.20.MIP.3A}{Observed concentration of CCL.20.MIP.3A cytokine.}
#'   \item{IL.12.P70}{Observed concentration of IL.12.P70 cytokine.}
#'   \item{IL.13}{Observed concentration of IL.13 cytokine.}
#'   \item{IL.15}{Observed concentration of IL.15 cytokine.}
#'   \item{IL.17A}{Observed concentration of IL.17A cytokine.}
#'   \item{IL.22}{Observed concentration of IL.22 cytokine.}
#'   \item{IL.9}{Observed concentration of IL.9 cytokine.}
#'   \item{IL.1B}{Observed concentration of IL.1B cytokine.}
#'   \item{IL.33}{Observed concentration of IL.33 cytokine.}
#'   \item{IL.2}{Observed concentration of IL.2 cytokine.}
#'   \item{IL.21}{Observed concentration of IL.21 cytokine.}
#'   \item{IL.4}{Observed concentration of IL.4 cytokine.}
#'   \item{IL.23}{Observed concentration of IL.23 cytokine.}
#'   \item{IL.5}{Observed concentration of IL.5 cytokine.}
#'   \item{IL.6}{Observed concentration of IL.6 cytokine.}
#'   \item{IL.17E.IL.25}{Observed concentration of IL.17E.IL.25 cytokine.}
#'   \item{IL.27}{Observed concentration of IL.27 cytokine.}
#'   \item{IL.31}{Observed concentration of IL.31 cytokine.}
#'   \item{TNF.A}{Observed concentration of TNF.A cytokine.}
#'   \item{TNF.B}{Observed concentration of TNF.B cytokine.}
#'   \item{IL.28A}{Observed concentration of IL.28A cytokine.}
#' }
#' @source Example data compiled for cytokine profiling.
#' @references
#' Pugh GH, Fouladvand S, SantaCruz-Calvo S, Agrawal M, Zhang XD, Chen J,
#' Kern PA, Nikolajczyk BS.
#' T cells dominate peripheral inflammation in a cross-sectional analysis of
#' obesity-associated diabetes. \emph{Obesity (Silver Spring)}. 2022;30(10):
#' 1983–1994. doi:10.1002/oby.23528.
#'
#' @examples
#' data(ExampleData1)
"ExampleData1"

#' Example Cytokine Profiling Data 2.
#'
#' Contains observed concentrations of cytokines and their respective treatment
#' and groups, derived from:
#'
#' @format A data frame with 66 rows and 20 columns:
#' \describe{
#'  \item{Stimulation}{Stimulation assigned to the subjects.}
#'  \item{Group}{Group assigned to the subjects.}
#'  \item{IL.17F}{Observed concentration of IL.17F cytokine.}
#'  \item{GM.CSF}{Observed concentration of GM.CSF cytokine.}
#'  \item{IFN.G}{Observed concentration of IFN.G cytokine.}
#'  \item{IL.10}{Observed concentration of IL.10 cytokine.}
#'  \item{CCL.20}{Observed concentration of CCL.20 cytokine.}
#'  \item{IL.12}{Observed concentration of IL.12 cytokine.}
#'  \item{IL.13}{Observed concentration of IL.13 cytokine.}
#'  \item{IL.17A}{Observed concentration of IL.17A cytokine.}
#'  \item{IL.22}{Observed concentration of IL.22 cytokine.}
#'  \item{IL.9}{Observed concentration of IL.9 cytokine.}
#'  \item{IL.1B}{Observed concentration of IL.1B cytokine.}
#'  \item{IL.2}{Observed concentration of IL.2 cytokine.}
#'  \item{IL.21}{Observed concentration of IL.21 cytokine.}
#'  \item{IL.4}{Observed concentration of IL.4 cytokine.}
#'  \item{IL.5}{Observed concentration of IL.5 cytokine.}
#'  \item{IL.6}{Observed concentration of IL.6 cytokine.}
#'  \item{TNF.A}{Observed concentration of TNF.A cytokine.}
#'  \item{TNF.B}{Observed concentration of TNF.B cytokine.}
#'  }
#'
#' @source Example data compiled for cytokine profiling.
#'
#' @references
#' SantaCruz-Calvo S, Saraswat S, Hasturk H, Dawson DR, Zhang XD,
#' Nikolajczyk BS. Periodontitis and Diabetes Differentially Affect
#' Inflammation in Obesity. \emph{J Dent Res.} 2024;103(12):1313-1322.
#' doi:10.1177/00220345241280743
#'
#' @examples
#' data(ExampleData2)
"ExampleData2"

#' Example Cytokine Profiling Data 3.
#'
#' Contains observed concentrations of cytokines and their respective treatment
#' and groups, derived from:
#'
#' @format A data frame with 64 rows and 14 columns:
#' \describe{
#'  \item{Stimulation}{Stimulation assigned to the subjects.}
#'  \item{Group}{Group assigned to the subjects.}
#'  \item{GM.CSF}{Observed concentration of GM.CSF cytokine.}
#'  \item{IFN.G}{Observed concentration of IFN.G cytokine.}
#'  \item{IL.10}{Observed concentration of IL.10 cytokine.}
#'  \item{CCL.20.MIP.3A}{Observed concentration of CCL.20.MIP.3A cytokine.}
#'  \item{IL.12.P70}{Observed concentration of IL.12.P70 cytokine.}
#'  \item{IL.13}{Observed concentration of IL.13 cytokine.}
#'  \item{IL.15}{Observed concentration of IL.15 cytokine.}
#'  \item{IL.9}{Observed concentration of IL.9 cytokine.}
#'  \item{IL.1B}{Observed concentration of IL.1B cytokine.}
#'  \item{IL.21}{Observed concentration of IL.21 cytokine.}
#'  \item{IL.6}{Observed concentration of IL.6 cytokine.}
#'  \item{TNF.A}{Observed concentration of TNF.A cytokine.}
#'  }
#'
#' @source Example data compiled for cytokine profiling.
#'
#' @references
#' SantaCruz-Calvo S, Saraswat S, Hasturk H, Dawson DR, Zhang XD,
#' Nikolajczyk BS. Periodontitis and Diabetes Differentially Affect
#' Inflammation in Obesity. \emph{J Dent Res.} 2024;103(12):1313-1322.
#' doi:10.1177/00220345241280743
#'
#' @examples
#' data(ExampleData3)
"ExampleData3"

#' Example Cytokine Profiling Data 4.
#'
#' Contains observed concentrations of cytokines and their respective treatment
#' and groups, derived from:
#'
#' @format A data frame with 64 rows and 14 columns:
#' \describe{
#'  \item{Group}{Group assigned to the subjects.}
#'  \item{Treatment}{Treatment received by subjects.}
#'  \item{IL.17F}{Observed concentration of IL.17F cytokine.}
#'  \item{GM.CSF}{Observed concentration of GM.CSF cytokine.}
#'  \item{IFNg}{Observed concentration of IFNg cytokine.}
#'  \item{IL.10}{Observed concentration of IL.10 cytokine.}
#'  \item{CCL.20}{Observed concentration of CCL.20 cytokine.}
#'  \item{IL.12}{Observed concentration of IL.12 cytokine.}
#'  \item{IL.13}{Observed concentration of IL.13 cytokine.}
#'  \item{IL.17A}{Observed concentration of IL.17A cytokine.}
#'  \item{IL.22}{Observed concentration of IL.22 cytokine.}
#'  \item{IL.9}{Observed concentration of IL.9 cytokine.}
#'  \item{IL.2}{Observed concentration of IL.2 cytokine.}
#'  \item{IL.21}{Observed concentration of IL.21 cytokine.}
#'  \item{IL.4}{Observed concentration of IL.4 cytokine.}
#'  \item{IL.23}{Observed concentration of IL.23 cytokine.}
#'  \item{IL.5}{Observed concentration of IL.5 cytokine.}
#'  \item{IL.6}{Observed concentration of IL.6 cytokine.}
#'  \item{TNFa}{Observed concentration of TNFa cytokine.}
#'  \item{TNFb}{Observed concentration of TNFb cytokine.}
#'  }
#'
#' @source Example data compiled for cytokine profiling.
#'
#' @references
#' SantaCruz-Calvo, S., Saraswat, S., Kalantar, G. H., Zukowski, E.,
#' Marszalkowski, H., Javidan, A., Gholamrezaeinejad, F., Bharath, L. P.,
#' Kern, P. A., Zhang, X. D., & Nikolajczyk, B. S. (2024).
#' A unique inflammaging profile generated by T cells from people with obesity
#' is metformin resistant. \emph{GeroScience}, 10.1007/s11357-024-01441-4.
#' Advance online publication. https://doi.org/10.1007/s11357-024-01441-4
#'
#' @examples
#' data(ExampleData4)
"ExampleData4"

#' Example Cytokine Profiling Data 5.
#'
#' Contains observed concentrations of cytokines and their respective treatment
#' and groups, derived from:
#'
#' @format A data frame with 297 rows and 29 columns:
#' \describe{
#'   \item{Group}{Group assigned to the subjects.}
#'   \item{Treatment}{Treatment received by subjects.}
#'   \item{Batch}{Batch number corresponding to the sample.}
#'   \item{Time}{Time point of the measurement.}
#'   \item{IL.17F}{Observed concentration of IL.17F cytokine.}
#'   \item{GM.CSF}{Observed concentration of GM.CSF cytokine.}
#'   \item{IFN.G}{Observed concentration of IFN.G cytokine.}
#'   \item{IL.10}{Observed concentration of IL.10 cytokine.}
#'   \item{CCL.20.MIP.3A}{Observed concentration of CCL.20.MIP.3A cytokine.}
#'   \item{IL.12.P70}{Observed concentration of IL.12.P70 cytokine.}
#'   \item{IL.13}{Observed concentration of IL.13 cytokine.}
#'   \item{IL.15}{Observed concentration of IL.15 cytokine.}
#'   \item{IL.17A}{Observed concentration of IL.17A cytokine.}
#'   \item{IL.22}{Observed concentration of IL.22 cytokine.}
#'   \item{IL.9}{Observed concentration of IL.9 cytokine.}
#'   \item{IL.1B}{Observed concentration of IL.1B cytokine.}
#'   \item{IL.33}{Observed concentration of IL.33 cytokine.}
#'   \item{IL.2}{Observed concentration of IL.2 cytokine.}
#'   \item{IL.21}{Observed concentration of IL.21 cytokine.}
#'   \item{IL.4}{Observed concentration of IL.4 cytokine.}
#'   \item{IL.23}{Observed concentration of IL.23 cytokine.}
#'   \item{IL.5}{Observed concentration of IL.5 cytokine.}
#'   \item{IL.6}{Observed concentration of IL.6 cytokine.}
#'   \item{IL.17E.IL.25}{Observed concentration of IL.17E.IL.25 cytokine.}
#'   \item{IL.27}{Observed concentration of IL.27 cytokine.}
#'   \item{IL.31}{Observed concentration of IL.31 cytokine.}
#'   \item{TNF.A}{Observed concentration of TNF.A cytokine.}
#'   \item{TNF.B}{Observed concentration of TNF.B cytokine.}
#'   \item{IL.28A}{Observed concentration of IL.28A cytokine.}
#' }
#' @source Example data compiled for cytokine profiling.
#' @references
#' Pugh GH, Fouladvand S, SantaCruz-Calvo S, Agrawal M, Zhang XD, Chen J,
#' Kern PA, Nikolajczyk BS.
#' T cells dominate peripheral inflammation in a cross-sectional analysis of
#' obesity-associated diabetes. \emph{Obesity (Silver Spring)}. 2022;30(10):
#' 1983–1994. doi:10.1002/oby.23528.
#'
#' @note
#' The ExampleData5 dataset is the same data as ExampleData1 but with a new
#' column "Batch" added to indicate the batch number corresponding to each sample.
#' The "Batch" column was randomly generated to simulate batch effects in the data.
#'
#' @examples
#' data(ExampleData5)
"ExampleData5"
