% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_daisie_datatable.R
\name{as_daisie_datatable}
\alias{as_daisie_datatable}
\title{Converts the \code{Island_tbl} class to a data frame in the format of a DAISIE
data table (see DAISIE R package for details). This can then be input into
\code{DAISIEprep::create_daisie_data()} function which creates the list input into
the DAISIE ML models.}
\usage{
as_daisie_datatable(island_tbl, island_age, precise_col_time = TRUE)
}
\arguments{
\item{island_tbl}{An instance of the \code{Island_tbl} class.}

\item{island_age}{Age of the island in appropriate units.}

\item{precise_col_time}{Boolean, TRUE uses the precise times of colonisation,
FALSE makes every colonist a max age colonistion and uses minimum age of
colonisation if available.}
}
\value{
A data frame in the format of a DAISIE data table
}
\description{
Converts the \code{Island_tbl} class to a data frame in the format of a DAISIE
data table (see DAISIE R package for details). This can then be input into
\code{DAISIEprep::create_daisie_data()} function which creates the list input into
the DAISIE ML models.
}
\examples{
phylod <- create_test_phylod(10)
island_tbl <- extract_island_species(
  phylod = phylod,
  extraction_method = "asr"
)

# Example where precise colonisation times are known
daisie_datatable <- as_daisie_datatable(
  island_tbl = island_tbl,
  island_age = 0.2,
  precise_col_time = TRUE
)

# Example where colonisation times are uncertain and set to max ages
daisie_datatable <- as_daisie_datatable(
  island_tbl = island_tbl,
  island_age = 0.2,
  precise_col_time = FALSE
)
}
\author{
Joshua W. Lambert, Pedro Neves
}
