% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePartial4Groups.R
\name{computePartial4Groups}
\alias{computePartial4Groups}
\title{Computes group alphas 
and group factor scores
for \eqn{K} groups of observations 
in \code{distatis}.}
\usage{
computePartial4Groups(resDistatis, DESIGN)
}
\arguments{
\item{resDistatis}{The results of
a Distatis analysis (as performed by
the \code{DistatisR::distatis}) function.}

\item{DESIGN}{A Design vector describing
the groups of observations}
}
\value{
A list with
\itemize{ 
 \item{"GroupFS: "}{
     The \eqn{K} weighted mean coordinates}
  \item{"groupAlpha: "}{
     The \eqn{K} alpha weights}
    }
}
\description{
\code{computePartial4Groups}:
Computes group alphas and group factor scores
for \eqn{K} groups of observations used to compute
the compromise (i.e., matrix **S**)
in a \code{distatis} analysis.
}
\details{
In DISTATIS, the compromise
is computed as a weighted 
(with the alpha-coefficients) sum of the 
\eqn{K} pseudo-covariance matrices 
**S**k,  \code{computePartial4Groups}
sums all the alpha coefficients of a group
to compute each group partial factor scores.
}
\seealso{
\code{\link{distatis}}
}
\author{
Hervé Abdi
}
