\name{modified_schwefel}
\alias{modified_schwefel}
\title{Modified Schwefel Function for Benchmarking Optimization Algorithms}

\usage{
modified_schwefel(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the modified Schwefel function is evaluated.
  }
}

\value{
Returns a numeric value representing the evaluation of the modified Schwefel function at the input vector \code{x}.
}

\description{
The modified Schwefel function is a challenging test function for optimization algorithms due to its complex landscape with numerous local minima. It is a modified version of the original Schwefel function, further increasing its difficulty.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(-420.9687462275036, 4)
modified_schwefel(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
modified_schwefel(x)

# Contour Plot: Visualizing the Modified Schwefel Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) modified_schwefel(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Modified Schwefel Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = modified_schwefel, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) modified_schwefel(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Modified Schwefel Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Schwefel, H.-P. (1981). Numerical Optimization of Computer Models. \emph{John Wiley & Sons}.
}
