% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{read.plates}
\alias{read.plates}
\title{Read the ELISA OD files}
\usage{
read.plates(
  fileName,
  annotations,
  num.plate = 1,
  batchID,
  expID,
  date = NA_character_
)
}
\arguments{
\item{fileName}{characters containing file name of OD data}

\item{annotations}{list of data containing annotations of the plates}

\item{num.plate}{numeric number of OD plates in the OD file.}

\item{batchID}{characters specify the batchID read from the design file}

\item{expID}{characters specify the expID or plateID read from the design file}

\item{date}{characters the date running the ELISA exps.}
}
\value{
an object of elisa_run holding data and annotations for 
	one or multiple plates.
}
\description{
Read the ELISA OD file to parse the ODs.
}
\details{
The input is a text file imported from the sdf file.  
The file may contain multiple plates of OD. We will parse 
each file section and then read them according to the 
annotation to load the data. We assume for each file the data
are for the same batch and experiment. If otherwise, please 
split the file into different ones.
}
\examples{
#get example annotation file path from the system folder
ann<-system.file("extdata", "annote.txt", package="ELISAtools")
std.conc<-system.file("extdata", "stdConc.txt", package="ELISAtools")

#read them in and there are 2 plates.
annotations<-read.annotations(annotation=ann,  std.conc=std.conc, num.plate=2)

#now start reading the OD plate file
fileName <-system.file("extdata", "Assay_3_and_4.txt", package="ELISAtools")
plates<-read.plates(fileName, annotations=annotations, num.plate=2, batchID="b1", expID="e1")

}
