% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{EQRN_predict_params_seq}
\alias{EQRN_predict_params_seq}
\title{GPD parameters prediction function for an EQRN_seq fitted object}
\usage{
EQRN_predict_params_seq(
  fit_eqrn,
  X,
  Y,
  intermediate_quantiles = NULL,
  return_parametrization = c("classical", "orthogonal"),
  interm_lvl = fit_eqrn$interm_lvl,
  seq_len = fit_eqrn$seq_len,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_seq"} object.}

\item{X}{Matrix of covariates to predict conditional GPD parameters.}

\item{Y}{Response variable vector corresponding to the rows of \code{X}.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{return_parametrization}{Which parametrization to return the parameters in, either \code{"classical"} or \code{"orthogonal"}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used to predict each response quantile.
By default, the training \code{fit_eqrn$seq_len} is used.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Named list containing: \code{"scales"} and \code{"shapes"} as numerical vectors of length \code{nrow(X)},
and the \code{seq_len} used.
}
\description{
GPD parameters prediction function for an EQRN_seq fitted object
}
