% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_directory}
\alias{check_directory}
\title{Check directory existence}
\usage{
check_directory(dir_name, recursive = TRUE, no_warning = FALSE)
}
\arguments{
\item{dir_name}{Path to the desired directory, as a string.}

\item{recursive}{Should elements of the path other than the last be created?
If \code{TRUE}, behaves like the Unix command \code{mkdir -p}.}

\item{no_warning}{Whether to cancel the warning issued if a directory is created (bool).}
}
\value{
No return value.
}
\description{
Checks if the desired directory exists. If not, the desired directory is created.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
check_directory("./some_folder/my_new_folder")
\dontshow{
setwd(.old_wd)
}
}
