% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LlrCalibration.R
\name{calibrateLlr}
\alias{calibrateLlr}
\title{Calibrate the log likelihood ratio}
\usage{
calibrateLlr(null, likelihoodApproximation, twoSided = FALSE, upper = TRUE)
}
\arguments{
\item{null}{An object of class \code{null} created using the \code{fitNull} function or an
object of class \code{mcmcNull} created using the \code{fitMcmcNull} function.}

\item{likelihoodApproximation}{Either a data frame containing normal, skew-normal, or custom parametric likelihood
approximations, or a list of (adaptive) grid likelihood profiles.}

\item{twoSided}{Compute two-sided (TRUE) or one-sided (FALSE) p-value?}

\item{upper}{If one-sided: compute p-value for upper (TRUE) or lower (FALSE) bound?}
}
\value{
The calibrated log likelihood ratio.
}
\description{
\code{calibrateLlr} computes calibrated log likelihood ratio using the fitted null distribution
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitNull(negatives$logRr, negatives$seLogRr)
positive <- sccs[sccs$groundTruth == 1, ]
calibrateLlr(null, positive)

}
