% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_parameter_samples}
\alias{extract_parameter_samples}
\title{Extract Parameter Samples from a Stan Model}
\usage{
extract_parameter_samples(
  stan_fit,
  data,
  reported_dates,
  reported_inf_dates,
  drop_length_1 = FALSE,
  merge = FALSE
)
}
\arguments{
\item{stan_fit}{A \verb{<stanfit>} or \verb{<CmdStanMCMC>} object as returned by
\code{\link[=fit_model]{fit_model()}}.}

\item{data}{A list of the data supplied to the \code{\link[=fit_model]{fit_model()}} call.}

\item{reported_dates}{A vector of dates to report estimates for.}

\item{reported_inf_dates}{A vector of dates to report infection estimates
for.}

\item{drop_length_1}{Logical; whether the first dimension should be dropped
if it is off length 1; this is necessary when processing simulation results.}

\item{merge}{if TRUE, merge samples and data so that parameters can be
extracted from data.}
}
\value{
A list of \verb{<data.frame>}'s each containing the posterior of a
parameter
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Extracts a custom set of parameters from a stan object and adds
stratification and dates where appropriate.
}
\keyword{internal}
