% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{regional_summary}
\alias{regional_summary}
\title{Regional Summary Output}
\usage{
regional_summary(
  regional_output = NULL,
  data,
  results_dir = NULL,
  summary_dir = NULL,
  target_date = NULL,
  region_scale = "Region",
  all_regions = TRUE,
  return_output = is.null(summary_dir),
  plot = TRUE,
  max_plot = 10,
  ...
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{\link[=regional_epinow]{regional_epinow()}}
and stored in the \code{regional} list.}

\item{data}{A \verb{<data.frame>} of confirmed cases (confirm) by date
(date), and region (\code{region}).}

\item{results_dir}{An optional character string indicating the location of
the results directory to extract results from.}

\item{summary_dir}{A character string giving the directory
in which to store summary of results.}

\item{target_date}{A character string giving the target date for which to
extract results
(in the format "yyyy-mm-dd"). Defaults to latest available estimates.}

\item{region_scale}{A character string indicating the name to give the
regions being summarised.}

\item{all_regions}{Logical, defaults to \code{TRUE}. Should summary plots for all
regions be returned rather than just regions of interest.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned,
this automatically updates to TRUE if no directory for saving is specified.}

\item{plot}{Logical, defaults to \code{TRUE}. Should regional summary plots be
produced.}

\item{max_plot}{Numeric, defaults to 10. A multiplicative upper bound on the\
number of cases shown on the plot. Based on the maximum number of reported
cases.}

\item{...}{Additional arguments passed to \code{report_plots}.}
}
\value{
A list of summary measures and plots
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Used to produce summary output either internally in \code{regional_epinow} or
externally.
}
\examples{
# get example output from regional_epinow model
regional_out <- readRDS(system.file(
    package = "EpiNow2", "extdata", "example_regional_epinow.rds"
))

regional_summary(
  regional_output = regional_out$regional,
  data = regional_out$summary$reported_cases
)
}
\seealso{
regional_epinow
}
