% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{add_breakpoints}
\alias{add_breakpoints}
\title{Add breakpoints to certain dates in a data set.}
\usage{
add_breakpoints(data, dates = as.Date(character(0)))
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally
this can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument.}

\item{dates}{A vector of dates to use as breakpoints.}
}
\value{
A data.table with \code{breakpoint} set to 1 on each of the specified
dates.
}
\description{
Add breakpoints to certain dates in a data set.
}
\examples{
reported_cases <- add_breakpoints(example_confirmed, as.Date("2020-03-26"))
}
