% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estresse.R
\name{stind}
\alias{stind}
\title{Stress indices for genotype selection}
\usage{
stind(
  GEN,
  YS,
  YC,
  index = "ALL",
  bygen = TRUE,
  verbose = FALSE,
  plot = FALSE,
  xlab = "Genotype",
  ylab = "Values",
  ...
)
}
\arguments{
\item{GEN}{The column with the genotypes to be selected.}

\item{YS}{Productivity of the genotype without stress conditions.}

\item{YC}{Genotype productivity under stressful conditions.}

\item{index}{Index to be calculated (Standard 'ALL'). The indices to be used
are: 'STI' - Stress Tolerance Index, 'YI' - Yield Index, 'GMP' - Geometric Mean
Productivity, 'MP' - Mean Productivity, 'MH' - Harmonic Mean, 'SSI' - Stress
Stability Index, 'YSI' - Yield Stability Index, 'RSI' - Relative Stress Index.}

\item{bygen}{Returns the average of each genotype if 'TRUE'. Only in this way
it will be possible to plot graphs.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Plot graph if equal to 'TRUE' (Standard 'FALSE').}

\item{xlab}{Adjust the title of the x-axis in the graph.}

\item{ylab}{Adjust the title of the y-axis in the graph.}

\item{...}{General ggplot2 parameters for graph customization.}
}
\value{
Returns a table with the genotypes and the selected indices.
The higher the index value, the more resilient the genotype.
}
\description{
Selection indices for genotypes conducted under stress conditions cited
by Ghazvini et al. (2024).
}
\examples{
library(EstimateBreed)

data("aveia")

#General
index <- with(aveia,stind(GEN,MC,MG,index = "ALL",bygen=TRUE))

#Only the desired index
STI <- with(aveia,stind(GEN,MC,MG,index = "STI",bygen=TRUE))
}
\references{
Ghazvini, H., Pour-Aboughadareh, A., Jasemi, S.S. et al.
A Framework for Selection of High-Yielding and Drought-tolerant
Genotypes of Barley: Applying Yield-Based Indices and Multi-index Selecion
Models. Journal of Crop Health 76, 601-616 (2024).
\doi{10.1007/s10343-024-00981-1}
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
