% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treesWoffset.R
\name{drop.dummy.mb}
\alias{drop.dummy.mb}
\title{Remove dummy tip from Mr. Bayes summary trees, accounting for metadata on the tips}
\usage{
drop.dummy.mb(
  tree.file,
  output.file = NULL,
  dummy.name = "dummy",
  convert.ages = TRUE
)
}
\arguments{
\item{tree.file}{path to file containing the tree with dummy tip}

\item{output.file}{path to file to write converted tree. If \code{NULL} (default), the tree is simply returned.}

\item{dummy.name}{name of the added dummy tip, default \code{dummy}.}

\item{convert.ages}{whether height metadata should be converted to height - offset (required to plot e.g. HPD intervals correctly). Default TRUE.}
}
\value{
list of \code{tree} converted tree (as treedata) ; and \code{offset} age of the youngest tip in the final tree
}
\description{
This method is designed to remove the dummy tip added to a dataset before running with Mr. Bayes.
}
\examples{
# Remove the dummy tip from the summary tree
final_tree <- drop.dummy.mb(system.file("extdata", "tree_mb_dummy.tre", package = "EvoPhylo"))

}
\seealso{
\code{\link[=drop.dummy.beast]{drop.dummy.beast()}} for the same function using summary trees with a "dummy" extant from BEAST2
}
