% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datBarplot.R
\name{datBarplot}
\alias{datBarplot}
\title{Data - Generates frequency barplot.}
\usage{
datBarplot(
  x,
  xvar = NULL,
  yvar = "FREQ",
  grpvar = NULL,
  errbars = FALSE,
  x.order = NULL,
  sevar = NULL,
  psevar = NULL,
  device.type = "dev.new",
  jpeg.res = 300,
  device.height = 5,
  device.width = 8,
  horiz = FALSE,
  toplabelvar = NULL,
  ylim = NULL,
  divideby = NULL,
  ylabel = NULL,
  xlabel = NULL,
  mar = NULL,
  addlegend = FALSE,
  main = NULL,
  cex.main = 1,
  cex.label = 1,
  cex.names = 0.8,
  las.xnames = 0,
  las.ynames = 1,
  savedata = FALSE,
  outfolder = NULL,
  outfn = NULL,
  outfn.pre = NULL,
  outfn.date = TRUE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{x}{Data frame or comma-delimited file (*.csv) - a frequency table.}

\item{xvar}{String. Name of X variable.}

\item{yvar}{String. Name of the y variable (e.g., FREQ).}

\item{grpvar}{String. Name of the variable for grouping.}

\item{errbars}{Logical. If TRUE, error bars are added to bar plot (sevar or
psevar must also be populated).}

\item{x.order}{String or Vector. Define order of xvar based on y values:
descending ("DESC") or ascending ("ASC") or vector of row numbers.  If NULL,
the order of the input table is used.}

\item{sevar}{String. Name of the variable with standard error values.}

\item{psevar}{String. Name of the variable with percent standard error.}

\item{device.type}{String. Type(s) of device for plotting ("dev.new", "jpg",
"pdf").}

\item{jpeg.res}{Integer. Resolution for jpeg image.}

\item{device.height}{Integer. Height (in inches) of barplot, if writing to
file.}

\item{device.width}{Integer. Width (in inches) of barplot, if writing to
file.}

\item{horiz}{Logical. If TRUE, bars are drawn horizontally with first bar at
the bottom.  If FALSE, bars are drawn vertically with first bar to the left
(barplot parameter).}

\item{toplabelvar}{String. Name of variable in x for adding labels to place
above each bar (e.g., NBRPLOTS.gt0).}

\item{ylim}{Number. A vector of min and max values, c(min,max) for the y
axis (or x axis if horiz=TRUE). If NULL, defaults to maximum y value. If
errbars=TRUE, the ylim defaults to the maximum y value plus the standard
error.}

\item{divideby}{String. Conversion number for output ('hundred', 'thousand',
'million').}

\item{ylabel}{String. Label for the y axis (same as ylab).}

\item{xlabel}{String. Label for the x axis (same as xlab).}

\item{mar}{See par.. A numerical vector representing number of lines for
margins (c(bottom, left, top, right).}

\item{addlegend}{Logical. If TRUE, adds legend to bar plot (only applicable
if grouping).}

\item{main}{String. Title for plot.}

\item{cex.main}{Number. Expansion factor for title.}

\item{cex.label}{Number. A number representing cex in barplot (size
expansion of x and/or ylabels.}

\item{cex.names}{Number. Expansion factor for axis names (bar labels) (e.g.,
0.5 represents half the size.}

\item{las.xnames}{Number. The direction of x variable names (0,1,3).
0:diagonal (Default), 1:horizontal; 3:vertical.}

\item{las.ynames}{Number. The direction of y variable names (0,1,3).
0:diagonal (Default), 1:horizontal; 3:vertical.}

\item{savedata}{Logical. If TRUE, writes output data to outfolder (jpg and
pdf).}

\item{outfolder}{String. The name of the output folder. If savedata=TRUE,
all output saved to the outfolder. If savedata=FALSE, only a text file of
input parameters is saved.}

\item{outfn}{String. The name of the output file if savedata=TRUE (*.csv).
Do not include extension. If NULL, the file will be named
BARPLOT_'yvar_date'.csv}

\item{outfn.pre}{String. Add a prefix to output name (e.g., "01").}

\item{outfn.date}{Logical. If TRUE, add date to end of outfile (e.g.,
outfn_'date'.csv).}

\item{overwrite}{Logical. If TRUE and exportshp=TRUE, overwrite files in
outfolder.}

\item{...}{additional arguments to pass to barplot(), including a list of
arguments for legend() arguments (e.g., args.legend=list(x="topleft",
bty="n"), for moving legend to topleft and removing box around legend).}
}
\value{
Outputs barplot to display window.
}
\description{
Generate a barplot of from a frequency data frame.
}
\details{
If parameters = NULL, then it will prompt user for input.
}
\note{
If savedata = TRUE, writes a jpg and pdf of barplot to outfolder.

To add legend parameters, add a parameter named args.legend, defined as a
list of specific legend parameters (see ?legend)...  e.g., 
args.legend=list(x="topright"). If specifying x and y, x defines the lower
right corner of legend box and y defines the upper right corner of box.
}
\examples{
# Set up data frame for example
ftyptab <- data.frame(cbind(FORTYPCD = c(182, 184, 201, 221, 265),
                            FREQ = c(110, 7, 900, 410, 155),
                            SE = c(10, 11, 18, 14, 22)))
                            
# Create basic barplot                           
datBarplot(x = ftyptab, xvar = "FORTYPCD")
	
# Add standard errors to basic barplot
datBarplot(x = ftyptab, xvar = "FORTYPCD", errbars = TRUE, sevar = "SE")
}
\author{
Tracey S. Frescino
}
\keyword{data}
