% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presens.aquaresp.R
\name{presens.aquaresp}
\alias{presens.aquaresp}
\title{Convert Respirometry Data from PreSens and AquaResp Software to the FishResp Format}
\usage{
presens.aquaresp(presens.file,
                 aquaresp.file,
                 fishresp.file,
                 n.chamber = c(1,2,3,4),
                 date.format = c("DMY", "MDY", "YMD"),
                 wait.phase = NA, measure.phase = NA)
}
\arguments{
\item{presens.file}{the name of a file which contains raw data obtained from the 'OxyView' software (\href{https://www.presens.de}{PreSens})}

\item{aquaresp.file}{the name of a file which contains summary data obtained from the 'AquaResp' software (\href{http://bioold.science.ku.dk/jfsteffensen/AquaResp.htm}{free software})}

\item{fishresp.file}{the name of an exported file containing raw data in the 'FishResp' format}

\item{n.chamber}{integer: the number of chambers used in an experiment (including empty ones)}

\item{date.format}{string: date format (DMY, MDY or YMD) used in raw data obtained from the 'OxyView' software}

\item{wait.phase}{integer: duration of the wait phase (in seconds), see the 'AquaResp' summary file (row #5)}

\item{measure.phase}{integer: duration of the measure phase (in seconds), see the 'AquaResp' summary file (row #6)}
}
\value{
The function exports a file containing raw data in the 'FishResp' format
}
\description{
The function is used to convert raw data from 'OxyView' (\href{https://www.presens.de}{PreSens}) and a summary file from 'AquaResp' (\href{http://bioold.science.ku.dk/jfsteffensen/AquaResp.htm}{free software}) to 'FishResp' format. This function should be applied before usage of the functions \code{\link{import.test}} and \code{\link{import.meas}}. The output is a file containing raw respirometry data in the 'FishResp' format (see Details in \code{\link{import.test}} to read more information about the 'FishResp' format)
}
\examples{

\dontrun{
presens.path.1 = system.file("extdata/presens/presens-ch1.txt",
                 package = "FishResp")
presens.path.2 = system.file("extdata/presens/presens-ch2.txt",
                 package = "FishResp")
presens.path.3 = system.file("extdata/presens/presens-ch3.txt",
                 package = "FishResp")
presens.path.4 = system.file("extdata/presens/presens-ch4.txt",
                 package = "FishResp")
aquaresp.path = system.file("extdata/presens/presens-aquaresp.txt",
                 package = "FishResp")

presens.aquaresp(presens.file = c(presens.path.1, presens.path.2,
                                  presens.path.3, presens.path.4),
                 aquaresp.file = aquaresp.path,
                 fishresp.file = "fishresp.txt",
                 date.format = "DMY",
                 n.chamber = 4,
                 wait.phase = 60,
                 measure.phase = 240)
}
}
