% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_profile.R
\name{species_profile}
\alias{species_profile}
\title{Species Profile Index After Pretzsch}
\usage{
species_profile(
  species_id,
  heights,
  weights = 1,
  n_rep = 1,
  reference_height = NULL
)
}
\arguments{
\item{species_id}{A vector of species codes, each vector element representing
a tree. Preferably, \code{species_id} is defined in one of the species
codings supported by this package, but technically, this is not even
a requirement.}

\item{heights}{A vector of tree heights, must have the same length as
\code{species_id}}

\item{weights}{A vector of weights for each tree, default = 1, i.e. all trees
are equally weighted. Must be of length 1 or the same length as
\code{species_id}. Useful if e.g. trees should be weighted by their basal
area.}

\item{n_rep}{A vector of representation numbers for each tree, typically the
number of trees represented per ha by each tree. Does only make a
difference if it differs among the trees. Default = 1, i.e. all trees have
the same representation number.}

\item{reference_height}{Reference height for the 100\% level of the stand
height profile. Internally passed to \code{\link{assmann_layers}}. If
\code{NULL} (default), the maximum of \code{heights} will be used as the
reference height.}
}
\value{
The Species Profile Index value resulting from the input data
}
\description{
As an extension of the Shannon Index (\code{\link{shannon_index}}), the
species profile index by
\insertCite{pretzsch_forest_2009;textual}{ForestElementsR}
takes into account the vertical structure of a forest stand. For doing so,
the function \code{\link{assmann_layers}} is called in the background.
}
\details{
Note that this function calculates comparable output only when the same
species coding is used for the input parameter \code{species_id}.
}
\examples{
  # Monospecific stand
  trees <- norway_spruce_1_fe_stand$trees
  species_profile(trees$species_id, trees$height_m)

  # Two-species mixed stand
  trees <- spruce_beech_1_fe_stand$trees
  species_profile(trees$species_id, trees$height_m)

  # Selection forest
  trees <- selection_forest_1_fe_stand$trees
  species_profile(trees$species_id, trees$height_m)

  # weigh with basal area (i.e. dbh^2)
  species_profile(trees$species_id, trees$height_m, weights = trees$dbh_cm^2)

  # weigh with inverse basal area (i.e. 1 / dbh^2)
  species_profile(
    trees$species_id, trees$height_m, weights = 1 / trees$dbh_cm^2
  )

}
\references{
\insertAllCited{}
}
\seealso{
Other structure and diversity: 
\code{\link{assmann_layers}()},
\code{\link{shannon_index}()}
}
\concept{structure and diversity}
