% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{ytable_max_slice}
\alias{ytable_max_slice}
\title{Take a Max Slice out of an fe_yield_table_object}
\usage{
ytable_max_slice(variable, ytable)
}
\arguments{
\item{variable}{Name of the yield table variable for which the slice is to
be taken}

\item{ytable}{Name of the yield table variable for which the slice is to
be taken}
}
\value{
A (named) vector representing the max slice of the desired
yield table variable. The names are the site indexes as defined in the
yield table's element \code{$site_index} (in the same order) with the
prefix "si_".
}
\description{
Max slices out of yield tables are typically required for finding out the
mai max site index for a given height based standard site index.
}
\details{
A max slice in the sense of this function means a vector that, for each of
the yield table's standard site indexes, contains the table's max value of
the variable of interest.
}
\examples{
  ytable_max_slice("mai_m3_ha_yr", fe_ytable_beech_wiedemann_moderate_1931)

}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()}
}
\concept{yield table functions}
