% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetAllOfGDELT.R
\name{GetAllOfGDELT}
\alias{GetAllOfGDELT}
\title{Download all the GDELT V1 Event files to a local folder}
\usage{
GetAllOfGDELT(
  local_folder,
  data_url_root = "http://data.gdeltproject.org/events/",
  force = FALSE
)
}
\arguments{
\item{local_folder}{character, path to the file to be validated.}

\item{data_url_root}{character, URL for the folder with GDELT data files.}

\item{force}{logical, if TRUE then the download is carried out without further prompting the user.}
}
\value{
logical, TRUE if all files were downloaded successfully.
}
\description{
Downloads all GDELT V1 Event files not already present locally. ** This takes a long time and a lot of space. **
}
\examples{
\dontrun{
GetAllOfGDELT("~/gdeltdata")} 
}
\references{
GDELT: Global Data on Events, Location and Tone, 1979-2013.  
Presented at the 2013 meeting of the International Studies Association
in San Francisco, CA.
\url{https://www.gdeltproject.org/}
}
\author{
\tabular{ll}{
  Stephen R. Haptonstahl \tab \email{srh@haptonstahl.org}\cr
}
}
