% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.binary.lsn.mtx.R
\name{prep.binary.lsn.mtx}
\alias{prep.binary.lsn.mtx}
\title{Prepare Binary Lesion Matrix}
\usage{
prep.binary.lsn.mtx(ov.data, min.ngrp = 0)
}
\arguments{
\item{ov.data}{list of six data.frames that represent the output results of the find.gene.lsn.overlaps function.}

\item{min.ngrp}{if specified, rows with number of patients affected by a specific type of lesion that's less than the specified number will be discarded (default is 0; function will return all genes affected by a lesion in at least one patient), for example if only one patient is affected by gain in MYB gene.}
}
\value{
The function returns a binary lesion matrix with each row labelled as gene.ID_lesion.type and each column is a patient. Entry for each patient in the table will be denoted as 1 if the gene is affected by this specific type of lesion or 0 otherwise.
}
\description{
Prepares a lesion matrix with each gene affected by a certain type of lesion as a row and each patient as a column.
}
\details{
The function uses the output results of the find.gene.lsn.overlaps function and create a binary lesion matrix with each gene affected by certain lesion type as a row and each patient as a column. Rownames are labelled as gene.ID_lesion.type (for example: ENSG00000118513_gain for gains affecting MYB gene). The entry for each patient in the table will be denoted as 1 if the patient is affected by this specific type of lesion in the gene, for example gain in MYB gene (ENSG00000118513) or 0 otherwise.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)

# prepare gene and lesion data for later computations:
prep.gene.lsn=prep.gene.lsn.data(lesion.data,
                                 hg19.gene.annotation)

# determine lesions that overlap each gene (locus):
gene.lsn.overlap=find.gene.lsn.overlaps(prep.gene.lsn)

# prepare the lesion binary matrix with a minimum of 5 patients affected by the lesion to be
# included in the final matrix:
lsn.binary.mtx=prep.binary.lsn.mtx(gene.lsn.overlap, min.ngrp=5)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=prep.gene.lsn.data]{prep.gene.lsn.data()}}, \code{\link[=find.gene.lsn.overlaps]{find.gene.lsn.overlaps()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
