% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_genomics.R
\name{TwoDimSFS}
\alias{TwoDimSFS}
\title{TwoDimSFS}
\usage{
TwoDimSFS(
  vcf_path,
  pop1_individuals,
  pop2_individuals,
  folded = FALSE,
  batch_size = 10000,
  threads = 1,
  write_log = FALSE,
  logfile = "log.txt",
  exclude_ind = NULL
)
}
\arguments{
\item{vcf_path}{Path to the VCF file.}

\item{pop1_individuals}{Vector of individual names belonging to the first population.}

\item{pop2_individuals}{Vector of individual names belonging to the second population.}

\item{folded}{Logical, deciding if folded (TRUE) or unfolded (FALSE) SFS is returned.}

\item{batch_size}{The number of variants to be processed in each batch
(default of 10,000 should be suitable for most use cases).}

\item{threads}{Number of threads to use for parallel processing.}

\item{write_log}{Logical, indicating whether to write progress logs.}

\item{logfile}{Path to the log file where progress will be logged.}

\item{exclude_ind}{Optional vector of individual IDs to exclude from the analysis.
If provided, the function will remove these individuals from the genotype matrix
before applying the custom function. Default is NULL, meaning no individuals are excluded.}
}
\value{
Two-dimensional site frequency spectrum as a matrix.
}
\description{
This function calculates a two-dimensional site frequency spectrum from a VCF file for two populations. It processes the file in batches for efficient memory usage.
The user can decide between a folded or unfolded spectrum.
}
\examples{
\donttest{vcf_file <- system.file("tests/testthat/sim.vcf.gz", package = "GenoPop")
index_file <- system.file("tests/testthat/sim.vcf.gz.tbi", package = "GenoPop")
pop1_individuals <- c("tsk_0", "tsk_1", "tsk_2")
pop2_individuals <- c("tsk_3", "tsk_4", "tsk_5")
sfs_2d <- TwoDimSFS(vcf_file, pop1_individuals, pop2_individuals, folded = TRUE)}

}
