% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hima_quantile.R
\name{hima_quantile}
\alias{hima_quantile}
\title{High-dimensional quantile mediation analysis}
\usage{
hima_quantile(
  X,
  M,
  Y,
  COV = NULL,
  penalty = c("MCP", "SCAD", "lasso"),
  topN = NULL,
  tau = 0.5,
  scale = TRUE,
  Bonfcut = 0.05,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{a vector of exposure. Do not use \code{data.frame} or \code{matrix}.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns
represent mediator variables.}

\item{Y}{a vector of continuous outcome. Do not use \code{data.frame} or \code{matrix}.}

\item{COV}{a matrix of adjusting covariates. Rows represent samples, columns represent variables. Can be \code{NULL}.}

\item{penalty}{the penalty to be applied to the model (a parameter passed to function \code{conquer.cv.reg} in package \code{conquer}.
Either \code{'MCP'} (the default), \code{'SCAD'}, or \code{'lasso'}.}

\item{topN}{an integer specifying the number of top markers from sure independent screening.
Default = \code{NULL}. If \code{NULL}, \code{topN} will be \code{2*ceiling(n/log(n))}, where \code{n} is the sample size.
If the sample size is greater than topN (pre-specified or calculated), all mediators will be included in the test (i.e. 
low-dimensional scenario).}

\item{tau}{quantile level of outcome. Default = \code{0.5}. A vector of tau is accepted.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{Bonfcut}{Bonferroni-corrected p value cutoff applied to select significant mediators. Default = \code{0.05}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}

\item{...}{reserved passing parameter.}
}
\value{
A data.frame containing mediation testing results of selected mediators (Bonferroni-adjusted p value <\code{Bonfcut}).
\describe{
    \item{Index: }{mediation name of selected significant mediator.}
    \item{alpha_hat: }{coefficient estimates of exposure (X) --> mediators (M) (adjusted for covariates).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta_hat: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for covariates and exposure).}
    \item{beta_se: }{standard error for beta.}
    \item{IDE: }{mediation (indirect) effect, i.e., alpha*beta.}
    \item{rimp: }{relative importance of the mediator.}
    \item{pmax: }{joint raw p-value of selected significant mediator (based on Bonferroni method).}
}
}
\description{
\code{hima_quantile} is used to estimate and test high-dimensional quantile mediation effects.
}
\examples{
\dontrun{
# Note: In the following example, M1, M2, and M3 are true mediators.

head(QuantileData$PhenoData)

hima_quantile.fit <- hima_quantile(
  X = QuantileData$PhenoData$Treatment,
  M = QuantileData$Mediator,
  Y = QuantileData$PhenoData$Outcome,
  COV = QuantileData$PhenoData[, c("Sex", "Age")],
  tau = c(0.3, 0.5, 0.7),
  scale = FALSE, # Disabled only for simulation data
  Bonfcut = 0.05,
  verbose = TRUE
)
hima_quantile.fit
}

}
\references{
Zhang H, Hong X, Zheng Y, Hou L, Zheng C, Wang X, Liu L. High-Dimensional Quantile Mediation Analysis with Application to a Birth
Cohort Study of Mother–Newborn Pairs. Bioinformatics. 2024. DOI: 10.1093/bioinformatics/btae055. PMID: 38290773; PMCID: PMC10873903
}
