% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccoef.r
\name{nzero_idx}
\alias{nzero_idx}
\title{Get Indices of Non-Zero Coefficients}
\usage{
nzero_idx(fit, cut = 0.1)
}
\arguments{
\item{fit}{An object of S3 class \code{htlr.fit}.}

\item{cut}{Threshold on relative SDB to distinguish zero coefficients.}
}
\value{
Indices vector of non-zero coefficients in the model.
}
\description{
Get the indices of non-zero coefficients from fitted HTLR model objects.
}
\examples{
set.seed(12345)
data("colon")

fit <- htlr(X = colon$X, y = colon$y, fsel = 1:100, iter = 20)
nzero_idx(fit)

}
