% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadGeoClass}
\alias{ReadGeoClass}
\title{Read a 'GeoClass.txt' File}
\usage{
ReadGeoClass(
  filename = "GeoClass.txt",
  encoding = c("unknown", "UTF-8", "Latin-1"),
  verbose = TRUE
)
}
\arguments{
\item{filename}{Path to and file name of the GeoClass file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{encoding}{Character string, encoding of non-ascii characters in imported text file. Particularly relevant when
importing files created under Windows (default encoding "Latin-1") in Linux (default encoding "UTF-8") and vice versa. See
also argument description in \code{\link[data.table]{fread}}.}

\item{verbose}{Print information on number of data columns in imported file.}
}
\value{
\code{ReadGeoClass} returns a data frame with added attribute 'comment'.
}
\description{
This is a convenience wrapper function to import a GeoClass file as data frame into R. GeoClass files contain definitions
of SLC (\bold{S}oil and \bold{L}and use \bold{C}rop) classes in twelve to 14 predefined columns, see
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:geoclass.txt}{GeoClass.txt documentation}.
}
\details{
\code{ReadGeoClass} is a convenience wrapper function of \code{\link[data.table]{fread}}, with treatment of leading
comment rows. Column names are created on import, optional comment rows are imported as strings in \code{attribute} 'comment'.
Optional inline comments (additional non-numeric columns) are automatically identified and imported along with data columns.
}
\examples{
te <- ReadGeoClass(filename = system.file("demo_model", "GeoClass.txt", package = "HYPEtools"))
te

}
\seealso{
\code{\link{ReadClassData}}
}
