% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spss.syntax.R
\name{spss.syntax}
\alias{spss.syntax}
\title{'SPSS' merge syntax}
\usage{
spss.syntax(filelist, name, outputdir = getwd(), zsav = TRUE, SPSSlimit = 50)
}
\arguments{
\item{filelist}{a character vector with the list of files to be merged.}

\item{name}{a string with the name of the merged file (without any
extension).}

\item{outputdir}{the directory where the \code{.sps} file and the
merged file will be saved.}

\item{zsav}{a logical value indicating if the the merged file should
be compressed with zsav. Default is \code{TRUE}.}

\item{SPSSlimit}{a numerical value indicating the limit of files per command
of 'SPSS', typically 50.}
}
\value{
Saves an \code{.sps} file with the 'SPSS' syntax for merging the
desired files.
}
\description{
Produces and saves an 'SPSS' merge syntax given a list of files.
}
\examples{
# Path were raw 'SPSS' files are
input <- system.file("extdata/reds", package = "ILSAmerge")

# Path were merged files will be saved
dir.create(file.path(tempdir(),"spsssyntax"))
output <- file.path(tempdir(),"spsssyntax")

# List of BCGV1 files to be merged
files <- list.files(path = input, pattern = "BCG.+V1|bcg.+v1")

# Create 'SPSS' syntax
spss.syntax(filelist = files, name = "BCGV1", outputdir = output, zsav = TRUE)

}
