\name{get_nbCluster_range}
\alias{get_nbCluster_range}
\alias{refine_nbCluster}
\alias{seq_nbCluster}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Control of number of components in Gaussian mixture modelling
}
\description{
These functions implement the default values for the number of components tried in Gaussian mixture modelling (matching the \code{nbCluster} argument of \code{Rmixmod::mixmodCluster()}). \code{get_nbCluster_range} allows the user to reproduce the internal rules used by \pkg{Infusion} to determine this argument. \code{seq_nbCluster} is a wrapper to the function defined by the \code{seq_nbCluster} global option of the package. Its default result is a sequence of integers determined by the number of rows of the data (see \code{\link{Infusion.options}}). \code{get_nbCluster_range()} further checks the feasibility of the values generated by \code{seq_nbCluster())}, using additional criteria involving the number of columns of the data to determine the maximum feasible number of clusters. This maximum is controlled by the function defined by the \code{maxnbCluster} global option of the package. 

\code{refine_nbCluster} controls the default number of clusters of \code{\link{refine}}: it gets the range from \code{seq_nbCluster} and keeps only the maximum value of this range if this maximum is higher than the \code{onlymax} argument.

Adventurous users can change the rules used by \pkg{Infusion} by changing the global options \code{seq_nbCluster} and \code{maxnbCluster} (while conforming to the interfaces of these functions). Less ambitiously, they can for example use the maximum value of the result of \code{get_nbCluster_range()} as a single reasonable value for the \code{nbCluster} argument of \code{infer_SLik_joint}.
}
\usage{
seq_nbCluster(nr)
refine_nbCluster(nr, onlymax=7)
get_nbCluster_range(projdata, nr = nrow(projdata), nc = ncol(projdata), 
                    nbCluster = seq_nbCluster(nr), verbose=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{projdata}{data frame: the data to be clustered, which typically include parameters and \bold{projected} summary statistics;}
  \item{nr}{integer: number of rows of the data to be clustered;}
  \item{onlymax}{integer: see Description;}
  \item{nc}{integer: number of columns of the data to be clustered, typically \bold{twice} the number of estimated parameters;}
  \item{nbCluster}{integer or vector of integers: candidate values, which feasability is checked by the function.}
  \item{verbose}{boolean. Whether to print some information, or not.}
}
\value{ An integer vector}
\examples{
# Determination of number of clusters when attempting to estimate 
#   20 parameters from a reference table with 30000 rows:
seq_nbCluster(nr=30000L)
get_nbCluster_range(nr=30000L, nc=40L) # nc = *twice* the number of parameters
}
