% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isofit.R
\name{isomultifit}
\alias{isomultifit}
\title{Fit isoscape models per strata (typically time interval such as months)}
\usage{
isomultifit(
  data,
  split_by = "month",
  mean_model_fix = list(elev = FALSE, lat_abs = FALSE, lat_2 = FALSE, long = FALSE,
    long_2 = FALSE),
  disp_model_fix = list(elev = FALSE, lat_abs = FALSE, lat_2 = FALSE, long = FALSE,
    long_2 = FALSE),
  mean_model_rand = list(uncorr = TRUE, spatial = TRUE),
  disp_model_rand = list(uncorr = TRUE, spatial = TRUE),
  uncorr_terms = list(mean_model = "lambda", disp_model = "lambda"),
  spaMM_method = list(mean_model = "fitme", disp_model = "fitme"),
  dist_method = "Earth",
  control_mean = list(),
  control_disp = list(),
  verbose = interactive()
)
}
\arguments{
\item{data}{The \emph{dataframe} containing the data used for fitting the
isoscape model}

\item{split_by}{A \emph{string} indicating the name of the column of
\code{data} used to split the dataset. The function
\code{\link{isofit}} will then be called on each of these sub-datasets. The
default behaviour is to consider that the dataset should be split per
months (\code{split_by = "month"}).}

\item{mean_model_fix}{A \emph{list} of \emph{logical} indicating which fixed
effects to consider in mean_fit}

\item{disp_model_fix}{A \emph{list} of \emph{logical} indicating which fixed
effects to consider in disp_fit}

\item{mean_model_rand}{A \emph{list} of \emph{logical} indicating which random
effects to consider in mean_fit}

\item{disp_model_rand}{A \emph{list} of \emph{logical} indicating which random
effects to consider in disp_fit}

\item{uncorr_terms}{A \emph{list} of two strings defining the parametrization
used to model the uncorrelated random effects for mean_fit and disp_fit}

\item{spaMM_method}{A \emph{list} of two strings defining the spaMM functions
used for mean_fit and disp_fit}

\item{dist_method}{A \emph{string} indicating the distance method}

\item{control_mean}{A \emph{list} of additional arguments to be passed to the
call of mean_fit}

\item{control_disp}{A \emph{list} of additional arguments to be passed to the
call of disp_fit}

\item{verbose}{A \emph{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \code{TRUE} if users use an interactive R
session and \code{FALSE} otherwise.}
}
\value{
This function returns a \emph{list} of class \emph{MULTIISOFIT}
containing all pairs of inter-related fits (stored under
\code{multi_fits}). The returned \emph{list} also contains the object
\code{info_fit} that contains all the call arguments.
}
\description{
This function fits several set of isoscapes (e.g. one per strata). It can thus be
used to predict annual averages precipitation weighted isoscapes.
}
\details{
This function is a wrapper around the function \code{\link{isofit}}.
}
\examples{

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. options_IsoriX(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if (getOption_IsoriX("example_maxtime") > 30) {
  ## We prepare the GNIP monthly data between January and June for Germany

  GNIPDataDEmonthly <- prepsources(
    data = GNIPDataDE,
    month = 1:6,
    split_by = "month"
  )

  head(GNIPDataDEmonthly)

  ## We fit the isoscapes

  GermanMonthlyFit <- isomultifit(data = GNIPDataDEmonthly)

  GermanMonthlyFit

  plot(GermanMonthlyFit)
}
}
\seealso{
\code{\link{isofit}} for information about the fitting procedure of
each isoscape.
}
