% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Birdkeepers.R
\docType{data}
\name{Birdkeepers}
\alias{Birdkeepers}
\title{Birdkeeping and Lung Cancer}
\format{
A data frame with 147 observations on the following 7 variables.
\itemize{
\item LC Whether subject has lung cancer
\item FM Sex of subject
\item SS Socioeconomic status, determined by occupation of the household's principal wage earner
\item BK Indicator for birdkeeping (caged birds in the home for more that 6 consecutive months from 5 to 14 years before diagnosis (cases) or examination (control))
\item AG Age of subject (in years)
\item YR Years of smoking prior to diagnosis or examination
\item CD Average rate of smoking (in cigarettes per day)
}
}
\source{
Ramsey, F.L. and Schafer, D.W. (2013). \emph{The Statistical Sleuth: A
Course in Methods of Data Analysis (3rd ed)}, Cengage Learning.
}
\usage{
data(Birdkeepers)
}
\description{
A 1972--1981 health survey in The Hague, Netherlands, discovered an
association between keeping pet birds and increased risk of lung
cancer.  To investigate birdkeeping as a risk factor, researchers
conducted a \emph{case--control} study of patients in 1985 at four
hospitals in The Hague (population 450,000).  They identified 49 cases
of lung cancer among the patients who were registered with a general
practice, who were age 65 or younger and who had resided in the city
since 1965.  They also selected 98 controls from a population of
residents having the same general age structure.
}
\details{
This dataset is copied and renamed from the Sleuth3 R package, where it is called case2002.
}
\references{
Holst, P.A., Kromhout, D. and Brand, R. (1988).  "For Debate: Pet Birds
as an Independent Risk Factor for Lung Cancer" \emph{British Medical Journal} \strong{297}: 13--21.
}
\keyword{datasets}
