% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photoperiod.R
\name{gg_photoperiod}
\alias{gg_photoperiod}
\title{Add photoperiods to gg_day() or gg_days() plots}
\usage{
gg_photoperiod(
  ggplot_obj,
  coordinates = NULL,
  alpha = 0.2,
  solarDep = 6,
  on.top = FALSE,
  ...
)
}
\arguments{
\item{ggplot_obj}{A \code{ggplot} object generated with \code{\link[=gg_day]{gg_day()}} or \code{\link[=gg_days]{gg_days()}}.}

\item{coordinates}{A two element numeric vector representing the latitude and
longitude of the location. If \code{NULL}, the default, the function will look
for the \code{dawn} and \code{dusk} columns in the dataset. If those are not present,
(and in the \code{POSIXct} format), the function will stop with an error.
Further, if \code{NULL}, the \code{solarDep} argument will be ignored.}

\item{alpha}{A numerical value between 0 and 1 representing the transparency
of the photoperiods. Default is 0.2.}

\item{solarDep}{A numerical value representing the solar depression angle
between 90 and -90. This means a value of 6 equals \strong{-6} degrees above the
horizon. Default is 6, equalling \verb{Civil dawn/dusk}. Other common values are
12 degrees for \verb{Nautical dawn/dusk}, 18 degrees for \verb{Astronomical dawn/dusk}, and 0 degrees for \code{Sunrise/Sunset}. Note that the output
columns will always be named \code{dawn} and \code{dusk}, regardless of the
\code{solarDep} value.}

\item{on.top}{Logical scalar. If \code{TRUE}, the photoperiods will be plotted on
top of the existing plot. If \code{FALSE}, the photoperiods will be plotted
underneath the existing plot. Default is \code{FALSE}.}

\item{...}{Additional arguments given to the \code{\link[ggplot2:geom_tile]{ggplot2::geom_rect()}} used to
construct the photoperiod shading. Can be used to change the fill color or
other aesthetic properties.}
}
\value{
a modified \code{ggplot} object with the photoperiods added.
}
\description{
\code{\link[=gg_photoperiod]{gg_photoperiod()}} is a helper function to add photoperiod information to
plots generated with \code{\link[=gg_day]{gg_day()}} or \code{\link[=gg_days]{gg_days()}}. The function can either draw
on the \code{dawn} and \code{dusk} columns of the dataset or use the \code{coordinates} and
\code{solarDep} arguments to calculate the photoperiods. For better visibility,
the
}
\details{
If used in combination with \code{\link[=gg_doubleplot]{gg_doubleplot()}}, with that function in the
\code{type = "repeat"} setting (either manually set, or because there is only one
day of data per group present), photoperiods need to be added separately
through \code{\link[=add_photoperiod]{add_photoperiod()}}, or the second photoperiod in each panel will be
off by one day. See the examples for more information.

In general, if the photoperiod setup is more complex, it makes sense to add
it prior to plotting and make sure the photoperiods are correct.
}
\examples{
coordinates <- c(48.521637, 9.057645)
#adding photoperiods to a ggplot
sample.data.environment |> 
  gg_days() |> 
  gg_photoperiod(coordinates)
  
#adding photoperiods prior to plotting
sample.data.environment |> 
  add_photoperiod(coordinates, solarDep = 0) |> 
  gg_days() |> 
  gg_photoperiod()
  
#more examples that are not executed for computation time:
\donttest{
#plotting photoperiods automatically works for both gg_day() and gg_days()
sample.data.environment |> 
  gg_day() |> 
  gg_photoperiod(coordinates)
  
#plotting for gg_doubleplot mostly works fine
sample.data.environment |> 
  filter_Date(length = "2 days") |> 
  gg_doubleplot() |> 
  gg_photoperiod(coordinates)

#however, in cases where only one day of data per group is available, or the 
#type = "repeat" setting is used, the photoperiods need to be added 
#separately. Otherwise the second day will be off by one day in each panel.
#The visual difference is subtle, and might not be visible at all, as 
#photoperiod only every changes by few minutes per day.

#WRONG
sample.data.environment |> 
  filter_Date(length = "1 days") |> 
  gg_doubleplot() |> 
  gg_photoperiod(coordinates)
  
#CORRECT
sample.data.environment |> 
  filter_Date(length = "1 days") |> 
  add_photoperiod(coordinates) |>
  gg_doubleplot() |> 
  gg_photoperiod()
  }
}
\seealso{
Other photoperiod: 
\code{\link{photoperiod}()}
}
\concept{photoperiod}
