% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qu_test.R
\name{Qu.test}
\alias{Qu.test}
\title{Qu test for true long memory against spurious long memory.}
\usage{
Qu.test(data, m, epsilon = 0.05)
}
\arguments{
\item{data}{data vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies used 
for the estimation usually \code{floor(1+T^delta)}, where 0.5<delta<0.8 for consistency.}

\item{epsilon}{trimming parameter \code{epsilon=0.05} by default. Determines
minimum number of Fourier frequencies used in test statistic. For T>500 it is recommended 
to use \code{epsilon=0.02}.Confer Qu (2011) for further details.}
}
\description{
\code{Qu.test} Test statistic of Qu (2011) for the null hypotesis of true long memory 
against the alternative of spurious long memory.
}
\examples{
library(fracdiff)
T<-500
m<-floor(1+T^0.75)
series<-fracdiff.sim(n=T,d=0.4)$series
shift.series<-ARRLS.sim(T=500,phi=0.5, sig.shift=0.75, prob=5/T, sig.noise=1)
ts.plot(series, ylim=c(min(min(series),min(shift.series)),max(max(series),max(shift.series))))
lines(shift.series, col=2)
Qu.test(series,m=m, epsilon=0.05)
Qu.test(shift.series,m=m, epsilon=0.05)
}
\references{
Qu, Z. (2011): A Test Against Spurious Long Memory. Journal of Business and 
Economic Statistics, Vol. 29, No. 3, pp. 423 - 438.
}
