% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-trajectory-R-decoupled.R
\name{sim_trajectory_base_R_decoupled_SIS}
\alias{sim_trajectory_base_R_decoupled_SIS}
\title{Simulate Trajectory From one SPN Model using Human SIS model}
\usage{
sim_trajectory_base_R_decoupled_SIS(
  x0,
  h0,
  SPN_P,
  theta,
  times,
  num_reps,
  stepFun,
  events = NULL,
  batch = NULL,
  Sout = NULL,
  verbose = TRUE,
  cube = NULL
)
}
\arguments{
\item{x0}{the initial marking of the SPN (initial state)}

\item{h0}{initial human state distribution}

\item{SPN_P}{stochastic petri net, places}

\item{theta}{parameters}

\item{times}{sequence of sampling times}

\item{num_reps}{number of repetitions to run}

\item{stepFun}{a sampling function}

\item{events}{a \code{data.frame} of events (uses the same format as required in package \code{deSolve} for consistency, see \code{\link[deSolve]{events}} for more information)}

\item{batch}{a \code{list} of batch migration events, created from \code{\link[MGDrivE2]{batch_migration}}, may be set to \code{NULL} if not used}

\item{Sout}{an optional matrix to track event firings}

\item{verbose}{print a progress bar?}

\item{cube}{inheritance cube}
}
\value{
matrix of sampled values
}
\description{
This is an internal function to \code{\link{sim_trajectory_R}}. It does the
actual sampling once all of the functions have been checked and setup.
}
