% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_estimation.R
\name{.mcee_core_rows}
\alias{.mcee_core_rows}
\title{Numerical core implementing MCEE estimation mathematics}
\usage{
.mcee_core_rows(
  n,
  f_nrows,
  omega_nrows,
  i_index,
  phi11_vec,
  phi10_vec,
  phi00_vec
)
}
\arguments{
\item{n}{Integer. Number of unique subjects.}

\item{f_nrows}{Matrix \eqn{nrows \times p}. Row \code{r} contains \eqn{f(t_r)^T},
the basis functions evaluated at the decision point for row \code{r}.}

\item{omega_nrows}{Numeric vector of length \code{nrows}. Per-row weights \eqn{\omega(i,t)}.}

\item{i_index}{Integer vector of length \code{nrows}. Subject index (1 to \code{n})
for each row, indicating which subject row \code{r} belongs to.}

\item{phi11_vec, phi10_vec, phi00_vec}{Numeric vectors of length \code{nrows}.
Influence function values for each row, computed from nuisance predictions.}
}
\value{
List containing:
\describe{
  \item{\code{alpha_hat}}{Vector of length \code{p}: NDEE parameter estimates}
  \item{\code{alpha_se}}{Vector of length \code{p}: NDEE standard errors}
  \item{\code{beta_hat}}{Vector of length \code{p}: NIEE parameter estimates}
  \item{\code{beta_se}}{Vector of length \code{p}: NIEE standard errors}
  \item{\code{varcov}}{Matrix \eqn{2p \times 2p}: Joint variance-covariance for \eqn{(\alpha,\beta)}}
  \item{\code{alpha_varcov}}{Matrix \eqn{p \times p}: Variance-covariance for \eqn{\alpha} only}
  \item{\code{beta_varcov}}{Matrix \eqn{p \times p}: Variance-covariance for \eqn{\beta} only}
}
}
\description{
Implements the core MCEE estimating equations and sandwich variance estimation.
This function contains the mathematical heart of the MCEE method, solving
the weighted estimating equations for \eqn{\alpha} (NDEE) and \eqn{\beta} (NIEE).
}
\details{
**MCEE Estimating Equations:**
\itemize{
  \item **NDEE**: \eqn{\alpha = S^{-1} \times (1/n) \sum_{i,t}\omega(i,t)\{\phi_t^{10} - \phi_t^{00}\} f(t)}
  \item **NIEE**: \eqn{\beta = S^{-1} \times (1/n) \sum_{i,t}\omega(i,t)\{\phi_t^{11} - \phi_t^{10}\} f(t)}
}
where \eqn{S = (1/n) \sum_{i,t}\omega(i,t) f(t)f(t)^T}.

**Sandwich Variance Formula:**
\eqn{\text{Var}((\alpha,\beta)) = \text{Bread}^{-1} \times \text{Meat} \times \text{Bread}^{-1,T} / n}, where:
\itemize{
  \item **Bread** = \eqn{\text{blockdiag}(S, S)} (\eqn{2p \times 2p} matrix)
  \item **Meat** = \eqn{(1/n) \sum_i U_i U_i^T}, with subject-level score vectors:
    \eqn{U_i = \sum_t \omega(i,t) \times [\{\phi_t^{10} - \phi_t^{00} - f^T\alpha\}f ; \{\phi_t^{11} - \phi_t^{10} - f^T\beta\}f]}
}

**Mathematical Details:**
The implementation follows the theoretical framework detailed in the MCEE vignette
appendix. The estimating equations are based on efficient influence functions
for the causal parameters of interest in the mediation analysis setting.
}
