% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRfilter.R
\name{utilMWRfilter}
\alias{utilMWRfilter}
\title{Filter results data by parameter, date range, site, result attributes, and/or location group}
\usage{
utilMWRfilter(
  resdat,
  sitdat = NULL,
  param,
  dtrng = NULL,
  site = NULL,
  resultatt = NULL,
  locgroup = NULL,
  alllocgroup = FALSE,
  allresultatt = FALSE
)
}
\arguments{
\item{resdat}{results data as returned by \code{\link{readMWRresults}}}

\item{sitdat}{site metadata file as returned by \code{\link{readMWRresults}}}

\item{param}{character string to filter results by a parameter in \code{"Characteristic Name"}}

\item{dtrng}{character string of length two for the date ranges as YYYY-MM-DD}

\item{site}{character string of sites to include, default all}

\item{resultatt}{character string of result attributes to include, default all}

\item{locgroup}{character string of location groups to include from the \code{"Location Group"} column in the site metadata file}

\item{alllocgroup}{logical indicating if results data are filtered by all location groups in \code{"Location Group"} in the site metadata file if \code{locgroup = NULL}, used only in \code{\link{anlzMWRdate}}}

\item{allresultatt}{logical indicating if results data are filtered by all result attributes if \code{resultatt = NULL}, used only in \code{\link{anlzMWRsite}}}
}
\value{
\code{resdat} filtered by \code{param}, \code{dtrng}, \code{site}, \code{resultatt}, and/or \code{locgroup}, otherwise \code{resdat} filtered only by \code{param} if other arguments are \code{NULL}
}
\description{
Filter results data by parameter, date range, site, result attributes, and/or location group
}
\examples{
# results file path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# site data path
sitpth <- system.file('extdata/ExampleSites.xlsx', package = 'MassWateR')

# site data
sitdat <- readMWRsites(sitpth)

# filter by parameter, date range
utilMWRfilter(resdat, param = 'DO', dtrng = c('2022-06-01', '2022-06-30'))

# filter by parameter, site
utilMWRfilter(resdat, param = 'DO', site = c('ABT-026', 'ABT-062', 'ABT-077'))

# filter by parameter, result attribute
utilMWRfilter(resdat, param = 'DO', resultatt = 'DRY')

# filter by parameter, location group, date range
utilMWRfilter(resdat, param = 'DO', sitdat = sitdat, 
     locgroup = 'Assabet', dtrng = c('2022-06-01', '2022-06-30'))
}
