% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{adonis_rarperm_pq}
\alias{adonis_rarperm_pq}
\title{Permanova (adonis) on permutations of rarefaction even depth}
\usage{
adonis_rarperm_pq(
  physeq,
  formula,
  dist_method = "bray",
  merge_sample_by = NULL,
  na_remove = FALSE,
  rarefy_nb_seqs = FALSE,
  verbose = TRUE,
  nperm = 99,
  progress_bar = TRUE,
  quantile_prob = 0.975,
  sample.size = min(sample_sums(physeq)),
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{formula}{(required) the right part of a formula for \code{\link[vegan:adonis]{vegan::adonis2()}}.
Variables must be present in the \code{physeq@sam_data} slot.}

\item{dist_method}{(default "bray") the distance used. See
\code{\link[phyloseq:distance]{phyloseq::distance()}} for all available distances or run
\code{\link[phyloseq:distanceMethodList]{phyloseq::distanceMethodList()}}.
For aitchison and robust.aitchison distance, \code{\link[vegan:vegdist]{vegan::vegdist()}}
function is directly used.}

\item{merge_sample_by}{a vector to determine
which samples to merge using the \code{\link[=merge_samples2]{merge_samples2()}}
function. Need to be in \code{physeq@sam_data}}

\item{na_remove}{(logical, default FALSE) If set to TRUE, remove samples with
NA in the variables set in formula.}

\item{rarefy_nb_seqs}{(logical, default FALSE) Rarefy each sample
(before merging if merge_sample_by is set) using
\code{phyloseq::rarefy_even_depth()}.
if \code{correction_for_sample_size} is TRUE, rarefy_nb_seqs will have no
effect.}

\item{verbose}{(logical, default TRUE) If TRUE, prompt some messages.}

\item{nperm}{(int, default = 99) The number of permutations to perform.}

\item{progress_bar}{(logical, default TRUE) Do we print progress during
the calculation.}

\item{quantile_prob}{(float, \verb{[0:1]}) the value to compute the quantile.
Minimum quantile is computed using 1-quantile_prob.}

\item{sample.size}{(int) A single integer value equal to the number of
reads being simulated, also known as the depth. See
\code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}}.}

\item{...}{Other params to be passed on to \code{\link[=adonis_pq]{adonis_pq()}} function}
}
\value{
A list of three dataframe representing the mean, the minimum quantile
and the maximum quantile value for adonis results. See \code{\link[=adonis_pq]{adonis_pq()}}.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Permanova are computed on a given number of rarefaction with different
seed.number. This reduce the risk of a random drawing of a exceptional
situation of an unique rarefaction.
}
\examples{
if (requireNamespace("vegan")) {
  data_fungi_woNA <-
    subset_samples(data_fungi, !is.na(Time) & !is.na(Height))
  adonis_rarperm_pq(data_fungi_woNA, "Time*Height", na_remove = TRUE, nperm = 3)
}
}
\seealso{
\code{\link[=adonis_pq]{adonis_pq()}}
}
\author{
Adrien Taudière
}
