% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{WH}
\alias{WH}
\title{Wetland Herbaceous Plant Traits Dataset}
\format{
A data frame with 46 rows and 23 variables:
\describe{
\item{Species}{Full scientific name of the species}
\item{species}{Abbreviated species name}
\item{ROH}{Root overwintering habits (P: Perennial, S: Autumn-senescing)}
\item{Height}{Shoot height (cm)}
\item{ShDM}{Shoot dry mass (g)}
\item{Depth}{Rooting depth (cm)}
\item{RBD}{Root branching density (no. cm^-1)}
\item{RBL}{Root branching length (cm cm^-1)}
\item{RD_AR}{Root diameter of axial roots (mm)}
\item{RD_LR}{Root diameter of lateral roots (mm)}
\item{RDMC_AR}{Root dry-matter content of axial roots (g g^-1)}
\item{RDMC_LR}{Root dry-matter content of lateral roots (g g^-1)}
\item{SRL_AR}{Specific root length of axial roots (m g^-1)}
\item{SRL_LR}{Specific root length of lateral roots (m g^-1)}
\item{RP_AR}{Root porosity of axial roots (mm^3 mm^-3)}
\item{RP_LR}{Root porosity of lateral roots (mm^3 mm^-3)}
\item{LT}{Leaf thickness (mm)}
\item{LDMC}{Leaf dry-matter content (g g^-1)}
\item{SLA}{Specific leaf area (m^2 kg^-1)}
\item{LP}{Leaf porosity (mm^3 mm^-3)}
\item{RhDMC}{Rhizome dry-matter content (g g^-1)}
\item{RhP}{Rhizome porosity (mm^3 mm^-3)}
\item{LSI}{Leaf senescence index (\% senescence)}
}
}
\source{
Ye, Z., Mu, Y., Van Duzen, S. and Ryser, P. (2024). Root and shoot phenology,
architecture, and organ properties: an integrated trait network among 44 herbaceous
wetland species. New Phytol. https://doi.org/10.1111/nph.19747
}
\usage{
WH
}
\description{
A dataset containing functional traits for 46 herbaceous wetland plant species grown in an experimental garden.
}
\details{
This dataset contains measurements of 21 below- and aboveground traits for 46 herbaceous
wetland species grown in a common garden setting. The study employs a detailed approach
to trait measurement on roots, leaves, shoots, and selectively on rhizomes. Root traits
are classified into functional entities – axial roots, lateral roots, and the entire
root system – to capture the functional variation in root branching structures.
Measurements include leaf morphology, porosity, and phenology, as well as
characterization of fibrous root systems by their phenology, branching architecture,
morphology, and tissue porosity.
}
\examples{
data(WH)
head(WH)
}
\keyword{datasets}
