% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateStage}
\alias{updateStage}
\title{Update Stage}
\usage{
updateStage(NGLVieweR_proxy, param = list())
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{param}{Of type list. Most common options are \code{backgroundColor}, \code{rotateSpeed}, \code{zoomSpeed},
\code{hoverTimeout} and \code{lightIntensity}. For a full list of options, see the "StageParameters" method in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Update an existing NGLVieweR stage in Shinymode.
}
\examples{
\dontrun{
NGLVieweR("7CID") \%>\%
 addRepresentation("cartoon", 
                   param = list(name = "cartoon", color="red")) \%>\%
 stageParameters(backgroundColor = "black")
}

if (interactive()) {
library(shiny)

ui = fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      selectInput("background", "Background", c("black", "white", "blue")),
      actionButton("update", "Update"),
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server <- function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon",
        param = list(name = "cartoon", color = "red")
      ) \%>\%
      stageParameters(backgroundColor = "black")
  })
  observeEvent(input$update, {
    NGLVieweR_proxy("structure") \%>\%
      updateStage(
      param = list("backgroundColor" = isolate(input$background)))
  })
}
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=stageParameters]{stageParameters()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateStage".
}

Other updates: 
\code{\link{updateColor}()},
\code{\link{updateRepresentation}()},
\code{\link{updateVisibility}()}
}
\concept{updates}
