#' Extended selection table of monk parakeet contact calls
#' 
#' Extended selection table of monk parakeet (\emph{Myiopsitta monachus}) contact calls.
#' 
#' @format One object of class extended selection table (following warbleR package format) and data frame. 
#'   
#' @description 'monk.parakeet.est' contains an \emph{extented selection table} following the warbleR package object format. The data contains the annotations and wave objects of 52 monk parake calls from four different social scales (flock individual, pair, site, 'scale' column). The 'ID' column labels selections belonging to the same individual when `scale == "Individual`. See Smith-Vidaurre, Araya-Salas & Wright (2019) for more details. 
#' 
#' @source Data used in Smith-Vidaurre, Araya-Salas & Wright (2019)
#' 
#' @references
#' Smith-Vidaurre G, Araya-Salas M, & Wright T F. 2019. Individual signatures outweigh social group identity in contact calls of a communally nesting parrot.  Behavioral Ecology.
#'         
#' @usage data(monk.parakeet.est)
"monk.parakeet.est" 
