% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nematode.info}
\alias{nematode.info}
\title{Nematode Taxonomic and Functional Traits}
\format{
A data frame with 2484 rows and 4 variables:
\describe{
\item{Genus}{Nematode genus name (character), e.g. "Parascaris", "Heterakis"}
\item{Family}{Taxonomic family name (character), e.g. "Ascarididae", "Heterakidae"}
\item{Feeding_habit}{Feeding behavior category (character), e.g. "Bacterial feeders", "Omnivores"}
\item{CP_group}{Colonizer-Persister group (numeric, 1-5)}
}
}
\source{
Nemaplex.UCDavis.edu; Revision Date: 07/08/2025; Accessed 07/16/2025
\itemize{
\item Website: \url{http://nemaplex.ucdavis.edu/}
}
}
\usage{
nematode.info
}
\description{
A dataset containing taxonomic classification and functional traits of nematode genera,
including feeding habits and ecological group (c-p value).
}
\details{
This dataset is particularly useful for:
\itemize{
\item Ecological studies of soil nematode communities
\item Trophic network analysis
\item Calculating nematode maturity indices (e.g. MI, PPI)
}
}
\examples{
# Load the data
data(nematode.info)

# Count nematodes by feeding habit
table(nematode.info$Feeding_habit)

# Find all genera in Ascarididae family
subset(nematode.info, Family == "Ascarididae")
}
\keyword{datasets}
