% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_ODT.R
\name{prune.ODT}
\alias{prune.ODT}
\title{pruning of class \code{ODT}}
\usage{
\method{prune}{ODT}(obj, X, y, MaxDepth = 1, ...)
}
\arguments{
\item{obj}{an object of class \code{ODT}.}

\item{X}{An n by d numeric matrix (preferable) or data frame is used to prune the object of class \code{ODT}.}

\item{y}{A response vector of length n.}

\item{MaxDepth}{The maximum depth of the tree after pruning. (Default 1)}

\item{...}{Optional parameters to be passed to the low level function.}
}
\value{
An object of class \code{ODT} and \code{prune.ODT}.
\itemize{
\item{\code{ODT} The same result as \code{ODT}.}
\item{\code{pruneError} Error of validation data after each pruning, misclassification rate (MR) for classification or mean square error (MSE) for regression.
The maximum value indicates the tree without pruning, and the minimum value (0) indicates indicates the data without splitting and using the average value as the predicted value.}
}
}
\description{
Prune \code{ODT} from bottom to top with validation data based on prediction error.
}
\details{
The leftmost value of the horizontal axis indicates the tree without pruning, while the rightmost value indicates the data without splitting and using the average value as the predicted value.
}
\examples{
# Classification with Oblique Decision Tree
data(seeds)
set.seed(221212)
train <- sample(1:209, 100)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
index <- seq(floor(nrow(train_data) / 2))
tree <- ODT(varieties_of_wheat ~ ., train_data[index, ], split = "entropy")
prune_tree <- prune(tree, train_data[-index, -8], train_data[-index, 8])
pred <- predict(prune_tree, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))

# Regression with Oblique Decision Tree
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
index <- seq(floor(nrow(train_data) / 2))
tree <- ODT(Density ~ ., train_data[index, ], split = "mse")
prune_tree <- prune(tree, train_data[-index, -1], train_data[-index, 1])
pred <- predict(prune_tree, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)

}
\seealso{
\code{\link{ODT}} \code{\link{plot.prune.ODT}} \code{\link{prune.ODRF}} \code{\link{online.ODT}}
}
\keyword{prune}
\keyword{tree}
