% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_tag_plot.R
\name{marker_tag_plot}
\alias{marker_tag_plot}
\title{Plot marker tag detections from Oregon RFID antenna readers}
\usage{
marker_tag_plot(x, tag, gap)
}
\arguments{
\item{x}{antenna data compiled using \code{\link{import_ORFID}} or \code{\link{join_multireader_data}}.}

\item{tag}{marker tag identification (character object).}

\item{gap}{minimum time gap in seconds between detections (optional).}
}
\value{
Returns a \pkg{ggplot2} object. If the plot is saved as a named object, \pkg{ggplot2} functions, including \code{\link[ggplot2]{theme}} commands can be used to customize plot aesthetics, including axis labels, grid lines, etc.
}
\description{
Creates a time series plot containing only detection data from a user-specified marker tag (unique tag number).
}
\details{
Creates a plot object displaying marker tag detections. If a minimum time gap is specified, time gaps greater than the minimum specified are highlighted in red. This allows the user to identify periods when marker tags were not being detected as frequently as expected.
}
\examples{
# Create a list containing compiled reader data:
readers <- list(reader_1, reader_2, reader_3)

# Join data into a multi-reader array:
PIT_data <- join_multireader_data(readers)

# Plot marker tag data and highlight gaps greater than 10 minutes.
marker_tag_plot(PIT_data, "0000_000000004978", gap = 600)
}
\seealso{
\code{\link{import_ORFID}} for importing data files from Oregon RFID ORMR and ORSR antenna readers.
\code{\link{join_multireader_data}} for combining data from Oregon RFID ORMR and ORSR antenna readers into a multi-reader array.
}
\author{
Hugo Marques <biohmarques@gmail.com>
}
