% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedGaussian.R
\name{MixedGaussianTemplate}
\alias{MixedGaussianTemplate}
\title{Create a template MixedGaussian object containing a regime for each model type}
\usage{
MixedGaussianTemplate(mg, modelTypes = NULL)
}
\arguments{
\item{mg}{a MixedGaussian object or an object that can be converted to such
via \code{\link{as.MixedGaussian}}.}

\item{modelTypes}{a (possibly named) character string
vector. Each such string denotes a mixed Gaussian regime model class, e.g.
the result of calling \code{MGPMDefaultModelTypes()}. If specified, an
attempt is made to match \code{PCMModelTypes(as.MixedGaussian(mg))}
with the elements of \code{modelTypes} and an error is raised if the match
fails. If not named, the model
types and regimes in the resulting MixedGaussian object are named by the
capital latin letters A,B,C,.... Default: \code{NULL}, which is interpreted
as \code{PCMModelTypes(as.MixedGaussian(mg, NULL))}.}
}
\value{
a MixedGaussian with the same global parameter settings as for mg,
the same modelTypes as \code{modelTypes}, and with a regime for each model type.
The function will stop with an error if \code{mg} is not convertible to
a MixedGaussian object or if there is a mismatch between the model types in
\code{mg} and \code{modelTypes}.
}
\description{
Create a template MixedGaussian object containing a regime for each model type
}
\examples{
mg <- MixedGaussianTemplate(PCMBaseTestObjects$model.ab.123.bSigmae_x)
mgTemplBMOU <- MixedGaussianTemplate(PCMBaseTestObjects$model.OU.BM)
}
