% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapPPdependence.R
\name{PPshapdependence}
\alias{PPshapdependence}
\title{Dependency plot}
\usage{
PPshapdependence(data_long, x, y=NULL, color_feature=NULL, smooth=TRUE)
}
\arguments{
\item{data_long}{\code{ppshapr_prep} class object.}

\item{x}{the independent variable to see}

\item{y}{the interaction effect by putting the values of the independent variables in different colors.}

\item{color_feature}{display other variables with color. Default value is NULL.}

\item{smooth}{geom_smooth option. Default value is TRUE.}
}
\value{
An object of the class \code{ggplot}
}
\description{
Dependency plot using \code{PPKernelSHAP}
}
\details{
Dependency plots are designed to show the effect of one independent variable on the model's prediction.
Each point corresponds to each row of the training data,
and the y axis corresponds the \code{PPKernelSHAP} value of the variable,
indicating how much knowing the value of the variable changes the output of the model
for the prediction of the data.
}
\examples{
data(dataXY)
testX <- dataXY[1,-1]
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
shap_long <- ppshapr_prep(Model, final.rule =5, method="simple")
PPshapdependence(shap_long,x = "X1")

}
