% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelMatchObject.R
\name{print.PanelMatch}
\alias{print.PanelMatch}
\title{Print PanelMatch objects.}
\usage{
\method{print}{PanelMatch}(x, ..., verbose)
}
\arguments{
\item{x}{a \code{PanelMatch} object}

\item{...}{additional arguments to be passed to \code{print}}

\item{verbose}{logical indicating whether or not underlying data should be printed in expanded/raw list form.
The verbose form is not recommended unless the data set is small. Default is FALSE}
}
\description{
Print PanelMatch objects.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem, 'wbcode2', 'year', 'dem', 'y')
PM.results <- PanelMatch(panel.data = dem.sub.panel,
                         lag = 4, 
                         refinement.method = "mahalanobis",
                         match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         lead = 0:4, forbid.treatment.reversal = FALSE)
print(PM.results)


}
