% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalibrationSummary.R
\name{getCalibrationSummary}
\alias{getCalibrationSummary}
\title{Get a sparse summary of the calibration}
\usage{
getCalibrationSummary(
  prediction,
  predictionType,
  typeColumn = "evaluation",
  numberOfStrata = 10,
  truncateFraction = 0.05
)
}
\arguments{
\item{prediction}{A prediction object as generated using the
\code{\link{predict}} functions.}

\item{predictionType}{The type of prediction (binary or survival)}

\item{typeColumn}{A column that is used to stratify the results}

\item{numberOfStrata}{The number of strata in the plot.}

\item{truncateFraction}{This fraction of probability values will be ignored when plotting, to
avoid the x-axis scale being dominated by a few outliers.}
}
\value{
A dataframe with the calibration summary
}
\description{
Get a sparse summary of the calibration
}
\details{
Generates a sparse summary showing the predicted probabilities and the observed fractions. Predictions are
stratified into equally sized bins of predicted probabilities.
}
\examples{
# simulate data
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 500, seed = 42)
# create study population, split into train/test and preprocess with default settings
population <- createStudyPopulation(plpData, outcomeId = 3)
data <- splitData(plpData, population, createDefaultSplitSetting())
data$Train$covariateData <- preprocessData(data$Train$covariateData)
saveLoc <- file.path(tempdir(), "calibrationSummary")
# fit a lasso logistic regression model using the training data
plpModel <- fitPlp(data$Train, modelSettings=setLassoLogisticRegression(seed=42),
                   analysisId=1, analysisPath=saveLoc)
calibrationSummary <- getCalibrationSummary(plpModel$prediction, 
                                            "binary", 
                                            numberOfStrata = 10,
                                            typeColumn = "evaluationType")
calibrationSummary
# clean up
unlink(saveLoc, recursive = TRUE)
}
