% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptide_plot.R
\name{create_peptide_plot}
\alias{create_peptide_plot}
\title{Create a peptide Plot}
\usage{
create_peptide_plot(
  data,
  y_axis_vars,
  x_axis_vars,
  y_expand = c(0.1, 0.15),
  x_expand = c(0.6, 0.6),
  theme_options = NULL,
  labs_options = NULL,
  color_fill_column,
  fill_gradient_options = list(),
  label_size = 3,
  add_domain = TRUE,
  domain = NULL,
  domain_start_column = "domain_start",
  domain_end_column = "domain_end",
  domain_type_column = "domain_type",
  domain_color = NULL,
  PTM = FALSE,
  PTM_type_column = "PTM_type",
  PTM_color = NULL,
  add_label = TRUE,
  label_column = "Character",
  label_value = NULL,
  column_order = NULL
)
}
\arguments{
\item{data}{A dataframe containing the PSM data or Area data got from peptide_cluster_quantification.}

\item{y_axis_vars}{A list of variables for the donor and type facets.}

\item{x_axis_vars}{A list of variables for the region facets.}

\item{y_expand}{A numeric vector of length 2 specifying the expansion for the y-axis. Default is \code{c(0.1, 0.15)}.}

\item{x_expand}{A numeric vector of length 2 specifying the expansion for the x-axis. Default is \code{c(0.6, 0.6)}.}

\item{theme_options}{A list of additional theme options to customize the plot. Default is an empty list.}

\item{labs_options}{A list of additional labs options to customize the plot labels. Default is an empty list.}

\item{color_fill_column}{The name of the column in \code{data_with_psm} to be used for the fill aesthetic. Default is 'PSM'.}

\item{fill_gradient_options}{A list of options for \code{scale_fill_gradient}. Default is an empty list.}

\item{label_size}{The size of the labels in the plot. Default is 3.}

\item{add_domain}{A logical value indicating whether to add domain like CDR (Complementarity-Determining Region) to the plot. Default is TRUE.}

\item{domain}{A dataframe containing the domain data with columns including 'domain_start', 'domain_end', and 'domain_type'.}

\item{domain_start_column}{The name of the column in \code{domain} containing the start position of the domain Default is 'domain_start'.}

\item{domain_end_column}{The name of the column in \code{domain} containing the end position of the domain Default is 'domain_end'.}

\item{domain_type_column}{The name of the column in \code{domain} containing the type of the domain Default is 'domain_type'.}

\item{domain_color}{A list of colors for the domain types. Default is NULL.}

\item{PTM}{A logical value indicating whether to include PTM (Post-Translational Modification) data in the plot. Default is FALSE.}

\item{PTM_type_column}{The name of the column in \code{data_with_psm} containing the type of the PTM. Default is 'PTM_type'.}

\item{PTM_color}{A list of colors for the PTM types. Default is NULL.}

\item{add_label}{A logical value indicating whether to add labels to the plot. Default is TRUE.}

\item{label_column}{The name of the column in \code{data_with_psm} containing the labels to be added to the plot. Default is 'Character'.}

\item{label_value}{A list of column names and their values to filter the data for the labels. Default is NULL.}

\item{column_order}{A list of column names and their order for the plot. Default is NULL.}
}
\value{
This function returns a ggplot object representing the PSM plot.
}
\description{
This function generates a peptide plot using the provided data and allows for customization of the plot layout.
}
\examples{
data <- data.frame(
  Character = c("X", "Y", "Z", "A", "A", "A"),
  Position = 1:6,
  Condition_1 = rep("Drug1", 6),
  Region_2 = rep("Arm_1", 6),
  Area = c(0.000000, 0.000000, 0.000000, 6.643856, 6.643856, 6.643856),
  Condition_2 = rep("Donor1", 6),
  Region_1 = rep("VH", 6),
  PTM = c(FALSE, TRUE, FALSE, FALSE, FALSE, FALSE),
  PTM_type = c(NA, "O", NA, NA, NA, NA)
)
domain <- data.frame(
  domain_type = c("CDR H1", "CDR H2", "CDR H3"),
  Region_1 = c("VH", "VH", "VH"),
  Region_2 = c("Arm_1", "Arm_1", "Arm_1"),
  Condition_1 = c("Drug1", "Drug1", "Drug1"),
  domain_start = c(1, 3, 5),
  domain_end = c(2, 4, 6)
)
x_axis_vars <- c("Region_2", "Region_1")
y_axis_vars <- c("Condition_2")
domain_color <- c(
"CDR H1" = "#F8766D",
"CDR H2" = "#B79F00",
"CDR H3" = "#00BA38",
"CDR L1" = "#00BFC4",
"CDR L2" = "#619CFF",
"CDR L3" = "#F564E3"
)
PTM_color <- c(
  "Ox" = "red",
  "Deamid" = "cyan",
  "Cam" = "blue",
  "Acetyl" = "magenta"
)
p <- create_peptide_plot(
  data,
  y_axis_vars,
  x_axis_vars,
  y_expand = c(0.2, 0.2),
  x_expand = c(0.5, 0.5),
  theme_options = list(),
  labs_options = list(title = "PSM Plot", x = "Position", fill = "PSM"),
  color_fill_column = 'Area',
  fill_gradient_options = list(),
  label_size = 5,
  add_domain = TRUE,
  domain = domain,
  domain_start_column = "domain_start",
  domain_end_column = "domain_end",
  domain_type_column = "domain_type",
  domain_color = domain_color,
  PTM = FALSE,
  PTM_type_column = "PTM_type",
  PTM_color = PTM_color,
  add_label = TRUE,
  label_column = "Character",
  label_value = NULL,
  column_order = list(Region_1 = 'VH,VL')
)
print(p)

}
