% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_sim_reward}
\alias{data_sim_reward}
\title{Simulated data for reward tags used to estimate reporting rate}
\format{
\subsection{\code{data_sim_reward}}{

A data frame with many rows and 2 columns

\describe{
\item{\code{cap_hist}.}{Capture history (1000, 1010, 0P00, 0P0P, 0010).}
\item{\code{freq}.}{Number of fish with this history.}
}
}
}
\usage{
data(data_sim_reward)
}
\description{
This is simulated data with the parameter values given in details.
}
\details{
\preformatted{
 data_sim_reward <-LP_TL_simulate(
      dt_type=dt_type,  #  permanent tag
      N=10000,
      cov1=function(N)         {rep(1,N)},
      cov2=function(cov1)      {rep(1,  length(cov1))},
      p1  =function(cov1, cov2){rep(.1, length(cov1))},
      pST =function(cov1, cov2){rep(.75,length(cov1))},
      rho1=function(cov1, cov2){rep(.70,length(cov1))},
      rho2=function(cov1, cov2){rep(1,  length(cov1))},  # permanent second tag
      p2  =function(cov1, cov2){rep(.1, length(cov1))},
      seed=45985, trace=FALSE)
# we don't have fish with both tags
data_sim_reward$cap_hist <- gsub("1P", "0P", data_sim_reward$cap_hist)
}
}
\keyword{datasets}
