% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{print.performance_analysis}
\alias{print.performance_analysis}
\title{Print Performance Analysis Results}
\usage{
\method{print}{performance_analysis}(x, ...)
}
\arguments{
\item{x}{performance_analysis object}

\item{...}{Additional arguments (unused)}
}
\value{
Invisible copy of x
}
\description{
S3 method for printing performance analysis with key metrics including
risk-adjusted returns, drawdown statistics, and benchmark comparison.
}
\examples{
data("sample_prices_weekly")
data("sample_prices_daily")
syms_all <- intersect(names(sample_prices_weekly)[-1], names(sample_prices_daily)[-1])
syms <- syms_all[seq_len(min(3L, length(syms_all)))]
P <- sample_prices_weekly[, c("Date", syms), with = FALSE]
D <- sample_prices_daily[,  c("Date", syms), with = FALSE]
mom <- calc_momentum(P, lookback = 12)
sel <- filter_top_n(mom, n = 3)
W   <- weight_equally(sel)
res <- run_backtest(P, W)
perf <- analyze_performance(res, D, benchmark_symbol = syms[1])
print(perf)  # or just: perf
}
