% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-delete.R
\name{redcap_delete}
\alias{redcap_delete}
\title{Delete records in a REDCap project}
\usage{
redcap_delete(
  redcap_uri,
  token,
  records_to_delete,
  arm_of_records_to_delete = NULL,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{records_to_delete}{A character vector of the project's \code{record_id}
values to delete.  Required.}

\item{arm_of_records_to_delete}{A single integer reflecting the arm
containing the records to be deleted.  Leave it as NULL if the project
has no arms and is not longitudinal. Required if the REDCap project
has arms.  See Details below.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{records_affected_count}: The number of records inserted or updated.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Delete existing records by their ID from REDCap.
}
\details{
REDCap requires that at least one \code{record_id} value be passed to
the delete call.

When the project has arms, REDCapR has stricter requirements than REDCap.
If the REDCap project has arms, a value must be passed to
\code{arm_of_records_to_delete}.  This is a different behavior than calling
the server through cURL --which if no  arm number is specified,
then all arms are cleared of the specified \code{record_id}s.

Note that all longitudinal projects technically have arms, even if
only one arm is defined.  Therefore a value of \code{arm_number} must be
specified for all longitudinal projects.
}
\examples{
if (FALSE) {
records_to_delete <- c(102, 103, 105, 120)

# Deleting from a non-longitudinal project with no defined arms:
REDCapR::redcap_delete(
  redcap_uri               = uri,
  token                    = token,
  records_to_delete        = records_to_delete,
)

# Deleting from a project that has arms or is longitudinal:
arm_number <- 2L # Not the arm name
REDCapR::redcap_delete(
  redcap_uri               = uri,
  token                    = token,
  records_to_delete        = records_to_delete,
  arm_of_records_to_delete = arm_number
)
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Jonathan Mang, Will Beasley
}
