% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset_names.R
\name{get_dataset_names}
\alias{get_dataset_names}
\title{get_dataset_names}
\usage{
get_dataset_names(
  vintage = NULL,
  filter_name_str = NULL,
  filter_title_str = NULL,
  ignore_case = TRUE,
  brief = TRUE
)
}
\arguments{
\item{vintage}{An optional numeric for the year to select the datasets. If NULL, then all the years are returned.}

\item{filter_name_str}{An optional character string by which to filter the resultant \code{data.table} using the
"name" column.}

\item{filter_title_str}{An optional character string by which to filter the resultant \code{data.table} using the
"title" column.}

\item{ignore_case}{A logical which if \code{FALSE} will not ignore case in filtering the "title" column.}

\item{brief}{A logical which if \code{TRUE} will return a resultant \code{data.table} with just columns
"name", "vintage", "title". The default is \code{TRUE}.}
}
\value{
A list with a \code{data.table} of dataset names (named "data")
and a vector of unique vintages (named "vintages").
}
\description{
Get the acronym names and descriptions of the Census Bureau's datasets.

Function produces a \code{data.table} of the Census Bureau's dataset acronym names
that can be used in other \code{RcensusPkg::} functions calling for a dataset acronym name.
See Census Bureau's publicly available \href{https://www.census.gov/data/developers/data-sets.html}{datasets}
for descriptions. Also see \href{https://www.census.gov/programs-surveys.html}{All Surveys and Programs}
}
\examples{
\dontrun{
  # Requests for Census Bureau descriptions takes well over 10
  #  seconds in most cases.
  library(jsonlite)
  library(data.table)
  library(httr)
  library(RcensusPkg)

  # Get descriptions/vintages for 2020 datasets with "acs5" in their name.
  acs5_datasets_ls <- RcensusPkg::get_dataset_names(
    vintage = 2020,
    filter_name_str = "acs5/"
  )
}

}
