% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeItemsSample}
\alias{computeItemsSample}
\title{Prediction of number of cells in colonies}
\usage{
computeItemsSample(data.sample, method, cluster, modelFile = NULL)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{method}{character vector specifying the name of the clustering result to use.}

\item{cluster}{character vector specifying the name of the cluster to consider for the application of the specific model.}

\item{modelFile}{character vector specifying the path and the name of the RData model file.}
}
\value{
data.sample list containing features, profiles and clustering results with the number of cells for each particle.
}
\description{
Apply a specific predictive model for counting of number of cells in colonies for each cluster.
}
\details{
computeItemsSample applies a specific predictive model for counting of number of cells in colonies for each cluster
}
\examples{
\donttest{ 
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))

colnames(dat) <- c("x","y")
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf)

x <- computeUnSupervised(x, K=3, method.name="K-means")
x <- computeItemsSample(x, method="K-means", cluster="Cluster 1", modelFile=NULL)# to be fixed !


}
}
\seealso{
\code{\link{itemsModel}}, \code{\link{countItems}}
}
\keyword{internal}
