% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.dfunc.R
\name{lines.dfunc}
\alias{lines.dfunc}
\title{lines.dfunc - Lines method for distance (detection) functions}
\usage{
\method{lines}{dfunc}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{An estimated distance function resulting from a call to
\code{dfuncEstim}.}

\item{newdata}{Data frame similar to the \code{newdata} parameter 
to \code{\link{lm}} containing new values for covariates in the distance function.
One distance function is computed and plotted for each row in the data frame. 
If \code{newdata} is NULL, the routine computes the mean of all numeric covariates
in the distance function and the mode of all factor covariates in 
the distance function. The new mean and mode vector is used to predict 
and plot a distance function.}

\item{\dots}{Parameters to \code{lines} used to control attributes like 
color, line width, line type, etc.}
}
\value{
A data frame containing the x and y coordinates of the 
plotted line(s) is returned invisibly.
}
\description{
Lines method for objects of class '\code{dfunc}'. Distance 
function line methods add distance functions to existing plots.
}
\examples{
set.seed(87654)
x <- rnorm(1000, mean=0, sd=20)
x <- x[x >= 0]
x <- units::set_units(x, "mi")
dfunc <- dfuncEstim(x~1, likelihood="halfnorm")
plot(dfunc, nbins = 40, col="lightgrey", border=NA, vertLines=FALSE)
lines(dfunc, col="grey", lwd=15)
lines(dfunc, col="black", lwd=5, lty = 2)

# Multiple lines 
data(sparrowDetectionData)
data(sparrowSiteData)
dfuncObs <- dfuncEstim(formula = dist ~ observer 
                     , likelihood = "halfnorm"
                     , detectionData = sparrowDetectionData
                     , siteData = sparrowSiteData)
plot(dfuncObs
   , vertLines = FALSE
   , lty = 0
   , col = c("grey","lightgrey")
   , border=NA
   , main="Detection by observer"
   , legend = FALSE)
y <- lines(dfuncObs
   , newdata = data.frame(observer = levels(sparrowSiteData$observer))
   , col = palette.colors(length(levels(sparrowSiteData$observer)))
   , lty = 1
   , lwd = 4)
head(y) # values returned, same as predict method

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{plot.dfunc}},
  \code{\link{print.abund}}
}
